/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class JobConfigHandler
extends AbstractExecutionGraphRequestHandler
implements RequestHandler.JsonResponse {
    public JobConfigHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionGraph graph, Map<String, String> params) throws Exception {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("jid", graph.getJobID().toString());
        gen.writeStringField("name", graph.getJobName());
        ExecutionConfig ec = graph.getExecutionConfig();
        if (ec != null) {
            Map ucVals;
            gen.writeObjectFieldStart("execution-config");
            gen.writeStringField("execution-mode", ec.getExecutionMode().name());
            gen.writeNumberField("max-execution-retries", ec.getNumberOfExecutionRetries());
            gen.writeNumberField("job-parallelism", ec.getParallelism());
            gen.writeBooleanField("object-reuse-mode", ec.isObjectReuseEnabled());
            ExecutionConfig.GlobalJobParameters uc = ec.getGlobalJobParameters();
            if (uc != null && (ucVals = uc.toMap()) != null) {
                gen.writeObjectFieldStart("user-config");
                for (Map.Entry ucVal : ucVals.entrySet()) {
                    gen.writeStringField((String)ucVal.getKey(), (String)ucVal.getValue());
                }
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

