/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;
import org.apache.flink.util.StringUtils;

public class JobCancellationHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManager) throws Exception {
        try {
            JobID jobid = new JobID(StringUtils.hexStringToByte((String)params.get("jobid")));
            if (jobManager != null) {
                jobManager.tell((Object)new JobManagerMessages.CancelJob(jobid));
                return "";
            }
            throw new Exception("No connection to the leading JobManager.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to cancel the job with id: " + params.get("jobid") + e.getMessage(), e);
        }
    }
}

