/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class JobAccumulatorsHandler
extends AbstractExecutionGraphRequestHandler
implements RequestHandler.JsonResponse {
    public JobAccumulatorsHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionGraph graph, Map<String, String> params) throws Exception {
        StringifiedAccumulatorResult[] allAccumulators = graph.getAccumulatorResultsStringified();
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeArrayFieldStart("job-accumulators");
        gen.writeEndArray();
        gen.writeArrayFieldStart("user-task-accumulators");
        for (StringifiedAccumulatorResult acc : allAccumulators) {
            gen.writeStartObject();
            gen.writeStringField("name", acc.getName());
            gen.writeStringField("type", acc.getType());
            gen.writeStringField("value", acc.getValue());
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

