/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class DashboardConfigHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    private final String configString;

    public DashboardConfigHandler(long refreshInterval) {
        TimeZone timeZome = TimeZone.getDefault();
        String timeZoneName = timeZome.getDisplayName();
        long timeZoneOffset = timeZome.getRawOffset();
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
            gen.writeStartObject();
            gen.writeNumberField("refresh-interval", refreshInterval);
            gen.writeNumberField("timezone-offset", timeZoneOffset);
            gen.writeStringField("timezone-name", timeZoneName);
            gen.writeStringField("flink-version", EnvironmentInformation.getVersion());
            EnvironmentInformation.RevisionInformation revision = EnvironmentInformation.getRevisionInformation();
            if (revision != null) {
                gen.writeStringField("flink-revision", revision.commitId + " @ " + revision.commitDate);
            }
            gen.writeEndObject();
            gen.close();
            this.configString = writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManagerGateway) {
        return this.configString;
    }
}

