/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.Map;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractSubtaskRequestHandler;

public abstract class AbstractSubtaskAttemptRequestHandler
extends AbstractSubtaskRequestHandler {
    public AbstractSubtaskAttemptRequestHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionVertex vertex, Map<String, String> params) throws Exception {
        int attempt;
        String attemptNumberString = params.get("attempt");
        if (attemptNumberString == null) {
            throw new RuntimeException("Attempt number parameter missing");
        }
        try {
            attempt = Integer.parseInt(attemptNumberString);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid attempt number parameter");
        }
        Execution currentAttempt = vertex.getCurrentExecutionAttempt();
        if (attempt == currentAttempt.getAttemptNumber()) {
            return this.handleRequest(currentAttempt, params);
        }
        if (attempt >= 0 && attempt < currentAttempt.getAttemptNumber()) {
            Execution exec = vertex.getPriorExecutionAttempt(attempt);
            return this.handleRequest(exec, params);
        }
        throw new RuntimeException("Attempt does not exist: " + attempt);
    }

    public abstract String handleRequest(Execution var1, Map<String, String> var2) throws Exception;
}

