/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractExecutionGraphRequestHandler;

public abstract class AbstractJobVertexRequestHandler
extends AbstractExecutionGraphRequestHandler {
    public AbstractJobVertexRequestHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public final String handleRequest(ExecutionGraph graph, Map<String, String> params) throws Exception {
        JobVertexID vid;
        String vidString = params.get("vertexid");
        if (vidString == null) {
            throw new IllegalArgumentException("vertexId parameter missing");
        }
        try {
            vid = JobVertexID.fromHexString((String)vidString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid JobVertexID string '" + vidString + "': " + e.getMessage());
        }
        ExecutionJobVertex jobVertex = graph.getJobVertex(vid);
        if (jobVertex == null) {
            throw new IllegalArgumentException("No vertex with ID '" + vidString + "' exists.");
        }
        return this.handleRequest(jobVertex, params);
    }

    public abstract String handleRequest(ExecutionJobVertex var1, Map<String, String> var2) throws Exception;
}

