/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.files;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.router.KeepAliveWrite;
import io.netty.handler.codec.http.router.Routed;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.webmonitor.JobManagerRetriever;
import org.apache.flink.runtime.webmonitor.files.MimeTypes;
import org.apache.flink.runtime.webmonitor.handlers.HandlerRedirectUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@ChannelHandler.Sharable
public class StaticFileServerHandler
extends SimpleChannelInboundHandler<Routed> {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(StaticFileServerHandler.class);
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final int HTTP_CACHE_SECONDS = 300;
    private final JobManagerRetriever retriever;
    private final Future<String> localJobManagerAddressFuture;
    private final FiniteDuration timeout;
    private final File rootPath;
    private final Logger logger;
    private String localJobManagerAddress;

    public StaticFileServerHandler(JobManagerRetriever retriever, Future<String> localJobManagerAddressPromise, FiniteDuration timeout, File rootPath) {
        this(retriever, localJobManagerAddressPromise, timeout, rootPath, DEFAULT_LOGGER);
    }

    public StaticFileServerHandler(JobManagerRetriever retriever, Future<String> localJobManagerAddressFuture, FiniteDuration timeout, File rootPath, Logger logger) {
        this.retriever = Preconditions.checkNotNull(retriever);
        this.localJobManagerAddressFuture = Preconditions.checkNotNull(localJobManagerAddressFuture);
        this.timeout = Preconditions.checkNotNull(timeout);
        this.rootPath = Preconditions.checkNotNull(rootPath);
        this.logger = Preconditions.checkNotNull(logger);
    }

    public void channelRead0(ChannelHandlerContext ctx, Routed routed) throws Exception {
        if (this.localJobManagerAddressFuture.isCompleted()) {
            Option<Tuple2<ActorGateway, Integer>> jobManager;
            if (this.localJobManagerAddress == null) {
                this.localJobManagerAddress = (String)Await.result(this.localJobManagerAddressFuture, (Duration)this.timeout);
            }
            HttpRequest request = routed.request();
            String requestPath = routed.path();
            if (requestPath.endsWith("/")) {
                requestPath = requestPath + "index.html";
            }
            if (requestPath.equals("/jobmanager/log") || requestPath.equals("/jobmanager/stdout")) {
                requestPath = "";
            }
            if ((jobManager = this.retriever.getJobManagerGatewayAndWebPort()).isDefined()) {
                String redirectAddress = HandlerRedirectUtils.getRedirectAddress(this.localJobManagerAddress, (Tuple2<ActorGateway, Integer>)((Tuple2)jobManager.get()));
                if (redirectAddress != null) {
                    HttpResponse redirect = HandlerRedirectUtils.getRedirectResponse(redirectAddress, requestPath);
                    KeepAliveWrite.flush((ChannelHandlerContext)ctx, (HttpRequest)routed.request(), (HttpResponse)redirect);
                } else {
                    this.respondAsLeader(ctx, request, requestPath);
                }
            } else {
                KeepAliveWrite.flush((ChannelHandlerContext)ctx, (HttpRequest)routed.request(), (HttpResponse)HandlerRedirectUtils.getUnavailableResponse());
            }
        } else {
            KeepAliveWrite.flush((ChannelHandlerContext)ctx, (HttpRequest)routed.request(), (HttpResponse)HandlerRedirectUtils.getUnavailableResponse());
        }
    }

    private void respondAsLeader(ChannelHandlerContext ctx, HttpRequest request, String requestPath) throws IOException, ParseException {
        RandomAccessFile raf;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        File file = new File(this.rootPath, requestPath);
        if (!file.exists()) {
            ClassLoader cl = StaticFileServerHandler.class.getClassLoader();
            try (InputStream resourceStream = cl.getResourceAsStream("web" + requestPath);){
                if (resourceStream == null) {
                    this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                    StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                this.logger.debug("Loading missing file from classloader: {}", (Object)requestPath);
                file.getParentFile().mkdirs();
                Files.copy(resourceStream, file.toPath(), new CopyOption[0]);
            }
        }
        if (!file.exists() || file.isHidden() || file.isDirectory() || !file.isFile()) {
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        String ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Responding 'NOT MODIFIED' for file '" + file.getAbsolutePath() + '\'');
            }
            StaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Responding with file '" + file.getAbsolutePath() + '\'');
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        StaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
        if (!requestPath.contains("log") && !requestPath.contains("out")) {
            StaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
        }
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
        ctx.write((Object)response);
        ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
        ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            this.logger.error("Caught exception", cause);
            StaticFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        StaticFileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 300);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)"private, max-age=300");
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String mimeType = MimeTypes.getMimeTypeForFileName(file.getName());
        String mimeFinal = mimeType != null ? mimeType : MimeTypes.getDefaultMimeType();
        response.headers().set("Content-Type", (Object)mimeFinal);
    }
}

