/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.buildinfo;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.work.DisableCachingByDefault;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfoProperties;
import org.springframework.boot.loader.tools.BuildPropertiesWriter;

@DisableCachingByDefault(because="Not worth caching")
public abstract class BuildInfo
extends DefaultTask {
    private final BuildInfoProperties properties = (BuildInfoProperties)this.getProject().getObjects().newInstance(BuildInfoProperties.class, new Object[]{this.getExcludes()});

    public BuildInfo() {
        this.getDestinationDir().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()));
    }

    @Internal
    public abstract SetProperty<String> getExcludes();

    @TaskAction
    public void generateBuildProperties() {
        try {
            BuildPropertiesWriter.ProjectDetails details = new BuildPropertiesWriter.ProjectDetails(this.properties.getGroupIfNotExcluded(), this.properties.getArtifactIfNotExcluded(), this.properties.getVersionIfNotExcluded(), this.properties.getNameIfNotExcluded(), this.properties.getTimeIfNotExcluded(), this.properties.getAdditionalIfNotExcluded());
            new BuildPropertiesWriter(new File(((Directory)this.getDestinationDir().get()).getAsFile(), "build-info.properties")).writeBuildProperties(details);
        }
        catch (IOException ex) {
            throw new TaskExecutionException((Task)this, (Throwable)ex);
        }
    }

    @OutputDirectory
    public abstract DirectoryProperty getDestinationDir();

    @Nested
    public BuildInfoProperties getProperties() {
        return this.properties;
    }

    public void properties(Action<BuildInfoProperties> action) {
        action.execute((Object)this.properties);
    }
}

