/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator;
import org.gradle.jvm.application.tasks.CreateStartScripts;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.tasks.application.CreateBootStartScripts;

final class ApplicationPluginAction
implements PluginApplicationAction {
    ApplicationPluginAction() {
    }

    public void execute(Project project) {
        ApplicationPluginConvention applicationConvention = (ApplicationPluginConvention)project.getConvention().getPlugin(ApplicationPluginConvention.class);
        DistributionContainer distributions = (DistributionContainer)project.getExtensions().getByType(DistributionContainer.class);
        Distribution distribution = (Distribution)distributions.create("boot");
        this.configureBaseNameConvention(project, applicationConvention, distribution);
        CreateStartScripts bootStartScripts = (CreateStartScripts)project.getTasks().create("bootStartScripts", this.determineCreateStartScriptsClass());
        bootStartScripts.setDescription("Generates OS-specific start scripts to run the project as a Spring Boot application.");
        ((TemplateBasedScriptGenerator)bootStartScripts.getUnixStartScriptGenerator()).setTemplate(project.getResources().getText().fromString(this.loadResource("/unixStartScript.txt")));
        ((TemplateBasedScriptGenerator)bootStartScripts.getWindowsStartScriptGenerator()).setTemplate(project.getResources().getText().fromString(this.loadResource("/windowsStartScript.txt")));
        project.getConfigurations().all(configuration -> {
            if ("bootArchives".equals(configuration.getName())) {
                CopySpec libCopySpec = project.copySpec().into((Object)"lib").from(new Object[]{() -> configuration.getArtifacts().getFiles()});
                libCopySpec.setFileMode(Integer.valueOf(420));
                distribution.getContents().with(new CopySpec[]{libCopySpec});
                bootStartScripts.setClasspath(configuration.getArtifacts().getFiles());
            }
        });
        bootStartScripts.getConventionMapping().map("outputDir", () -> new File(project.getBuildDir(), "bootScripts"));
        bootStartScripts.getConventionMapping().map("applicationName", () -> ((ApplicationPluginConvention)applicationConvention).getApplicationName());
        bootStartScripts.getConventionMapping().map("defaultJvmOpts", () -> ((ApplicationPluginConvention)applicationConvention).getApplicationDefaultJvmArgs());
        CopySpec binCopySpec = project.copySpec().into((Object)"bin").from(new Object[]{bootStartScripts});
        binCopySpec.setFileMode(Integer.valueOf(493));
        distribution.getContents().with(new CopySpec[]{binCopySpec});
    }

    private Class<? extends CreateStartScripts> determineCreateStartScriptsClass() {
        return this.isGradle64OrLater() ? CreateStartScripts.class : CreateBootStartScripts.class;
    }

    private boolean isGradle64OrLater() {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"6.4")) >= 0;
    }

    private void configureBaseNameConvention(Project project, ApplicationPluginConvention applicationConvention, Distribution distribution) {
        Method getDistributionBaseName = ApplicationPluginAction.findMethod(distribution.getClass(), "getDistributionBaseName");
        if (getDistributionBaseName != null) {
            try {
                Property distributionBaseName = (Property)distribution.getClass().getMethod("getDistributionBaseName", new Class[0]).invoke((Object)distribution, new Object[0]);
                distributionBaseName.getClass().getMethod("convention", Provider.class).invoke((Object)distributionBaseName, project.provider(() -> applicationConvention.getApplicationName() + "-boot"));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (distribution instanceof IConventionAware) {
            ((IConventionAware)distribution).getConventionMapping().map("baseName", () -> applicationConvention.getApplicationName() + "-boot");
        }
    }

    private static Method findMethod(Class<?> type, String name) {
        for (Method candidate : type.getMethods()) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return ApplicationPlugin.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(String name) {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(name));){
            int read;
            char[] buffer = new char[4096];
            StringWriter writer = new StringWriter();
            while ((read = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException ex) {
            throw new GradleException("Failed to read '" + name + "'", (Throwable)ex);
        }
    }
}

