/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.attributes;

import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.util.ApplContext;

public class AttributeOneOf
extends AttributeSelector {
    String value;
    String[] values;

    public AttributeOneOf(String name, String value) {
        this.setName(name);
        this.value = value;
        this.values = null;
    }

    public AttributeOneOf(ApplContext ac, String name, String value) {
        this(name, value);
        if (value.indexOf(32) >= 0) {
            ac.getFrame().addWarning("space", this.toString());
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.values = null;
    }

    @Override
    public boolean canApply(Selector other) {
        if (other instanceof AttributeAny) {
            return true;
        }
        if (other instanceof AttributeExact) {
            String exact = ((AttributeExact)other).getValue();
            return this.value.equals(exact);
        }
        if (other instanceof AttributeOneOf) {
            return true;
        }
        return other instanceof AttributeBegin;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName()).append("~=\"").append(this.value).append("\"]");
        return sb.toString();
    }

    private String[] computeValues() {
        this.values = this.value.split("\\s");
        return this.values;
    }

    @Override
    public void applyAttribute(ApplContext ac, AttributeSelector attr) {
        String name = this.getName();
        if (name.equals(attr.getName())) {
            if (this.values == null) {
                this.computeValues();
            }
            if (attr instanceof AttributeExact) {
                String val = ((AttributeExact)attr).getValue();
                boolean ok = false;
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    ok = val.equals(this.values[i]);
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            }
        }
    }
}

