/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css21;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css21.CssBorderBottomColor;
import org.w3c.css.properties.css21.CssBorderBottomStyle;
import org.w3c.css.properties.css21.CssBorderBottomWidth;
import org.w3c.css.properties.css21.CssBorderColor;
import org.w3c.css.properties.css21.CssBorderLeftColor;
import org.w3c.css.properties.css21.CssBorderLeftStyle;
import org.w3c.css.properties.css21.CssBorderLeftWidth;
import org.w3c.css.properties.css21.CssBorderRightColor;
import org.w3c.css.properties.css21.CssBorderRightStyle;
import org.w3c.css.properties.css21.CssBorderRightWidth;
import org.w3c.css.properties.css21.CssBorderStyle;
import org.w3c.css.properties.css21.CssBorderTopColor;
import org.w3c.css.properties.css21.CssBorderTopStyle;
import org.w3c.css.properties.css21.CssBorderTopWidth;
import org.w3c.css.properties.css21.CssBorderWidth;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorder
extends org.w3c.css.properties.css.CssBorder {
    public CssBorder() {
    }

    public CssBorder(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBorder(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssValueList valueList = new CssValueList();
        SideValues values = CssBorder.checkBorderSide(ac, this, expression, check2);
        this.shorthand = true;
        if (values.color != null) {
            valueList.add(values.color);
            this.borderColor = new CssBorderColor();
            this.borderColor.bottom = new CssBorderBottomColor();
            this.borderColor.bottom.value = values.color;
            this.borderColor.top = new CssBorderTopColor();
            this.borderColor.top.value = values.color;
            this.borderColor.left = new CssBorderLeftColor();
            this.borderColor.left.value = values.color;
            this.borderColor.right = new CssBorderRightColor();
            this.borderColor.right.value = values.color;
        }
        if (values.style != null) {
            valueList.add(values.style);
            this.borderStyle = new CssBorderStyle();
            this.borderStyle.bottom = new CssBorderBottomStyle();
            this.borderStyle.bottom.value = values.style;
            this.borderStyle.top = new CssBorderTopStyle();
            this.borderStyle.top.value = values.style;
            this.borderStyle.left = new CssBorderLeftStyle();
            this.borderStyle.left.value = values.style;
            this.borderStyle.right = new CssBorderRightStyle();
            this.borderStyle.right.value = values.style;
        }
        if (values.width != null) {
            valueList.add(values.width);
            this.borderWidth = new CssBorderWidth();
            this.borderWidth.bottom = new CssBorderBottomWidth();
            this.borderWidth.bottom.value = values.width;
            this.borderWidth.top = new CssBorderTopWidth();
            this.borderWidth.top.value = values.width;
            this.borderWidth.left = new CssBorderLeftWidth();
            this.borderWidth.left.value = values.width;
            this.borderWidth.right = new CssBorderRightWidth();
            this.borderWidth.right.value = values.width;
        }
        this.value = valueList;
    }

    protected static SideValues checkBorderSide(ApplContext ac, CssProperty caller, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue _width = null;
        CssIdent _style = null;
        CssValue _color = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val = ((CssNumber)val).getLength();
                }
                case 6: {
                    CssLength length = (CssLength)val;
                    if (!length.isPositive()) {
                        throw new InvalidParamException("negative-value", expression.getValue(), caller.getPropertyName(), ac);
                    }
                    _width = val;
                    break;
                }
                case 15: {
                    CssColor c = new CssColor();
                    c.setShortRGBColor(val.toString(), ac);
                    _color = c;
                    break;
                }
                case 3: {
                    _color = val;
                    break;
                }
                case 0: {
                    CssIdent id = (CssIdent)val;
                    if (transparent.equals(id)) {
                        _color = transparent;
                        break;
                    }
                    if (inherit.equals(id)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        _width = inherit;
                        _style = inherit;
                        _color = inherit;
                        break;
                    }
                    CssIdent match = CssBorderWidth.getMatchingIdent(id);
                    if (match != null) {
                        _width = match;
                        break;
                    }
                    match = CssBorderStyle.getMatchingIdent(id);
                    if (match != null) {
                        _style = match;
                        break;
                    }
                    _color = new CssColor(ac, id.toString());
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        return new SideValues(_width, _style, _color);
    }

    protected static class SideValues {
        CssValue width;
        CssValue style;
        CssValue color;

        SideValues(CssValue width, CssValue style, CssValue color) {
            this.width = width;
            this.style = style;
            this.color = color;
        }
    }
}

