/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.xml;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateXmlAdapter
extends XmlAdapter<String, LocalDate> {
    public String marshal(LocalDate date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar convertedDate = GregorianCalendar.from(ZonedDateTime.of(date, LocalTime.MIDNIGHT, ZoneId.systemDefault()));
        return DatatypeConverter.printDate((Calendar)convertedDate);
    }

    public LocalDate unmarshal(String value) {
        if (value == null) {
            return null;
        }
        Calendar parsed = DatatypeConverter.parseDate((String)value);
        return ZonedDateTime.ofInstant(parsed.toInstant(), parsed.getTimeZone().toZoneId()).toLocalDate();
    }
}

