/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import java.util.Objects;
import no.digipost.api.client.BrokerId;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.SenderOrganization;

public final class AuthorialSender {
    private final SenderId id;
    private final SenderOrganization organization;

    public static AuthorialSender resolve(BrokerId brokerId, MayHaveSender mayHaveAuthorialSender) {
        return mayHaveAuthorialSender.getSenderId().map(AuthorialSender::new).orElseGet(() -> mayHaveAuthorialSender.getSenderOrganization().map(AuthorialSender::new).orElseGet(() -> new AuthorialSender(brokerId.asSenderId())));
    }

    private AuthorialSender(SenderId senderId) {
        this.id = senderId;
        this.organization = null;
    }

    private AuthorialSender(SenderOrganization organization) {
        this.id = null;
        this.organization = organization;
    }

    public boolean is(Type type) {
        switch (type) {
            case ACCOUNT_ID: {
                return this.id != null;
            }
            case ORGANIZATION: {
                return this.organization != null;
            }
        }
        return false;
    }

    public SenderId getAccountId() {
        if (!this.is(Type.ACCOUNT_ID)) {
            throw new IllegalStateException("account id of " + AuthorialSender.class.getSimpleName() + " is null. Actual: " + this);
        }
        return this.id;
    }

    public SenderOrganization getOrganization() {
        if (!this.is(Type.ORGANIZATION)) {
            throw new IllegalStateException("organization of " + AuthorialSender.class.getSimpleName() + " is null. Actual: " + this);
        }
        return this.organization;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthorialSender) {
            AuthorialSender that = (AuthorialSender)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.organization);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("authorial sender ");
        if (this.is(Type.ACCOUNT_ID)) {
            s.append(" ID: ").append(this.id);
        } else if (this.is(Type.ORGANIZATION)) {
            s.append(" organization: ").append(this.organization);
        } else {
            s.append(" <undefined>");
        }
        return s.toString();
    }

    public static enum Type {
        ACCOUNT_ID,
        ORGANIZATION;

    }
}

