/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="entrypoint")
public class EntryPoint
extends Representation {
    @XmlElement(name="certificate", required=false)
    private String certificate;

    public EntryPoint(String certificate, Link ... links) {
        super(links);
        this.certificate = certificate;
    }

    public EntryPoint() {
    }

    public URI getInboxUri() {
        return this.getLinkByRelationName(Relation.GET_INBOX).getUri();
    }

    public URI getCreateMessageUri() {
        return this.getLinkByRelationName(Relation.CREATE_MESSAGE).getUri();
    }

    public URI getArchiveDocumentsUri() {
        return this.getLinkByRelationName(Relation.ARCHIVE_DOCUMENTS).getUri();
    }

    public URI getArchivesUri() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVES).getUri();
    }

    public URI getArchiveDocumentByUUIDUri(UUID uuid) {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_BY_UUID).getUri().resolve(uuid.toString());
    }

    public URI getArchiveDocumentByReferenceUri(String referenceid) {
        String referenceIdBase64 = Base64.getEncoder().encodeToString(referenceid.getBytes(StandardCharsets.UTF_8));
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENTS_BY_REFERENCEID).getUri().resolve(referenceIdBase64);
    }

    public URI getPrintEncryptionCertificate() {
        return this.getLinkByRelationName(Relation.GET_PRINT_ENCRYPTION_CERTIFICATE).getUri();
    }

    public URI getSearchUri() {
        return this.getLinkByRelationName(Relation.SEARCH).getUri();
    }

    public URI getAutocompleteUri() {
        return this.getLinkByRelationName(Relation.AUTOCOMPLETE).getUri();
    }

    public URI getIdentificationUri() {
        return this.getLinkByRelationName(Relation.IDENTIFY_RECIPIENT).getUri();
    }

    public URI getIdentificationWithEncryptionKeyUri() {
        return this.getLinkByRelationName(Relation.IDENTIFY_RECIPIENT_WITH_ENCRYPTION_KEY).getUri();
    }

    public URI getDocumentEventsUri() {
        return this.getLinkByRelationName(Relation.DOCUMENT_EVENTS).getUri();
    }

    public URI getSenderInformationUri() {
        return this.getLinkByRelationName(Relation.GET_SENDER_INFORMATION).getUri();
    }

    public String getCertificate() {
        return this.certificate;
    }

    @XmlElement(name="link")
    protected List<Link> getLink() {
        return this.links;
    }

    protected void setLink(List<Link> links) {
        this.links = links;
    }
}

