/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.http.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.DataBindingException;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.internal.ExceptionUtils;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.ErrorType;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.util.JAXBContextUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public final class HttpResponseUtils {
    public static InputStream safelyOfferEntityStreamExternally(CloseableHttpResponse response, EventLogger eventLogger) {
        HttpEntity entity = null;
        try {
            HttpResponseUtils.checkResponse((HttpResponse)response, eventLogger);
            entity = response.getEntity();
            return entity.getContent();
        }
        catch (IOException | RuntimeException e) {
            try (CloseableHttpResponse autoClosed = response;){
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException | RuntimeException entityConsumptionException) {
                e.addSuppressed(entityConsumptionException);
            }
            throw e instanceof DigipostClientException ? (DigipostClientException)e : new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage(), e);
        }
    }

    public static boolean responseOk(StatusLine status) {
        return status.getStatusCode() / 100 == 2;
    }

    public static boolean resourceAlreadyExists(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == 409;
    }

    public static void checkResponse(HttpResponse response, EventLogger eventLogger) {
        StatusLine status = response.getStatusLine();
        if (!HttpResponseUtils.responseOk(status)) {
            ErrorMessage error = HttpResponseUtils.fetchErrorMessageString(status, response.getEntity());
            eventLogger.log(error.toString());
            switch (status.getStatusCode()) {
                case 500: {
                    throw new DigipostClientException(ErrorCode.SERVER_ERROR, error.getErrorMessage());
                }
                case 503: {
                    throw new DigipostClientException(ErrorCode.API_UNAVAILABLE, error.getErrorMessage());
                }
            }
            throw new DigipostClientException(error);
        }
    }

    private static ErrorMessage fetchErrorMessageString(StatusLine statusLine, HttpEntity responseEntity) {
        byte[] responseContent;
        ErrorType errorType = ErrorType.fromResponseStatus(statusLine);
        if (responseEntity == null) {
            return new ErrorMessage(errorType, "status=" + statusLine + ", body=<empty>", new Link[0]);
        }
        try {
            responseContent = EntityUtils.toByteArray((HttpEntity)responseEntity);
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "status=" + statusLine + ", clientException=" + ExceptionUtils.exceptionNameAndMessage(e), e);
        }
        if (responseContent.length == 0) {
            return new ErrorMessage(errorType, "status=" + statusLine + ", body=<empty>", new Link[0]);
        }
        try {
            ErrorMessage errorMessage = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, new ByteArrayInputStream(responseContent), ErrorMessage.class);
            return errorMessage != null ? errorMessage.withMessage("status=" + statusLine + ", message=" + errorMessage.getErrorMessage()) : ErrorMessage.EMPTY;
        }
        catch (IllegalStateException | DataBindingException e) {
            return new ErrorMessage(errorType, errorType.name(), "status=" + statusLine + ", clientException=" + ExceptionUtils.exceptionNameAndMessage(e) + ", body=" + new String(responseContent), new Link[0]);
        }
        catch (Exception e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "status=" + statusLine + ", clientException=" + ExceptionUtils.exceptionNameAndMessage(e) + ", body=" + new String(responseContent), e);
        }
    }

    private HttpResponseUtils() {
    }
}

