/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import no.digipost.api.client.EventLogger;

public final class DigipostClientConfig {
    public final URI digipostApiUri;
    public final Duration printKeyCacheTimeToLive;
    public final EventLogger eventLogger;
    public final Clock clock;
    public final boolean failOnHtmlDiff;

    public static Builder newConfiguration() {
        return new Builder();
    }

    private DigipostClientConfig(URI digipostApiUri, Duration printKeyCacheTimeToLive, EventLogger eventLogger, Clock clock, boolean failOnHtmlDiff) {
        this.digipostApiUri = Objects.requireNonNull(digipostApiUri, "digipostApiUri cat not be null");
        this.printKeyCacheTimeToLive = Objects.requireNonNull(printKeyCacheTimeToLive, "printKeyCacheTimeToLive can not be null");
        this.eventLogger = Objects.requireNonNull(eventLogger, "eventLogger can not be null");
        this.clock = clock;
        this.failOnHtmlDiff = failOnHtmlDiff;
    }

    public static class Builder {
        private Duration printKeyCacheTimeToLive = Duration.ofMinutes(5L);
        private URI digipostApiUri = URI.create("https://api.digipost.no");
        private EventLogger eventLogger = EventLogger.NOOP_LOGGER;
        private Clock clock = Clock.systemDefaultZone();
        private boolean failOnHtmlDiff = false;

        private Builder() {
        }

        public Builder digipostApiUri(URI uri) {
            this.digipostApiUri = uri;
            return this;
        }

        public Builder disablePrintKeyCache() {
            return this.printKeyCacheTimeToLive(Duration.ZERO);
        }

        public Builder printKeyCacheTimeToLive(Duration cachePrintKey) {
            this.printKeyCacheTimeToLive = cachePrintKey;
            return this;
        }

        public Builder failOnHtmlSanitationDiff() {
            this.failOnHtmlDiff = true;
            return this;
        }

        public Builder eventLogger(EventLogger eventLogger) {
            this.eventLogger = eventLogger;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public DigipostClientConfig build() {
            return new DigipostClientConfig(this.digipostApiUri, this.printKeyCacheTimeToLive, this.eventLogger, this.clock, this.failOnHtmlDiff);
        }
    }
}

