/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.math.BigDecimal;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;

public abstract class JsonFactory {
    private JsonFactory() {
    }

    public static JsonString jsonString(String s) {
        return new JsonStringImpl(s);
    }

    public static JsonValue jsonNull() {
        return JsonValue.NULL;
    }

    public static JsonValue jsonBoolean(boolean b) {
        return b ? JsonValue.TRUE : JsonValue.FALSE;
    }

    public static JsonNumber jsonNumber(double s) {
        return JsonNumberImpl.getJsonNumber((double)s);
    }

    public static JsonNumber jsonNumber(long s) {
        return JsonNumberImpl.getJsonNumber((long)s);
    }

    public static JsonNumber jsonNumber(BigDecimal s) {
        return JsonNumberImpl.getJsonNumber((BigDecimal)s);
    }

    public static JsonNumber jsonNumber(Number s) {
        return JsonNumberImpl.getJsonNumber((BigDecimal)new BigDecimal(s.toString()));
    }

    public static JsonArray arrayOf(Iterable<JsonValue> values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        values.forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder.build();
    }

    public static JsonObject objectOf(Map<String, JsonValue> values) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        values.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        return builder.build();
    }
}

