/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren.util;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class StreamUtils {
    private StreamUtils() {
    }

    public static <A, B, C> Stream<C> zip(Stream<A> streamA, Stream<B> streamB, final BiFunction<A, B, C> zipper) {
        final Iterator iteratorA = streamA.iterator();
        final Iterator iteratorB = streamB.iterator();
        Iterator iteratorC = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(iteratorA.next(), iteratorB.next());
            }
        };
        boolean parallel = streamA.isParallel() || streamB.isParallel();
        return StreamUtils.iteratorToFiniteStream(iteratorC, parallel);
    }

    public static <T> Stream<T> iteratorToFiniteStream(Iterator<T> iterator, boolean parallel) {
        Iterable iterable = () -> iterator;
        return parallel ? StreamUtils.parallellStream(iterable) : StreamUtils.stream(iterable);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> parallellStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), true);
    }

    public static <T> Stream<T> stream(Optional<T> opt) {
        return opt.isPresent() ? Stream.of(opt.get()) : Stream.empty();
    }
}

