/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.net.URI;
import java.util.Optional;
import no.arktekk.siren.Classes;
import no.arktekk.siren.MIMEType;
import no.arktekk.siren.Rel;

public final class Link {
    public final Rel rel;
    public final URI href;
    public final Optional<Classes> classes;
    public final Optional<MIMEType> type;
    public final Optional<String> title;

    public Link(Rel rel, URI href, Optional<Classes> classes, Optional<MIMEType> type, Optional<String> title) {
        this.rel = rel;
        this.href = href;
        this.classes = classes;
        this.type = type;
        this.title = title;
    }

    public static Link of(Rel rel, URI href) {
        return new Link(rel, href, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Link with(Classes classes) {
        return new Link(this.rel, this.href, Optional.of(classes), this.type, this.title);
    }

    public Link with(MIMEType type) {
        return new Link(this.rel, this.href, this.classes, Optional.of(type), this.title);
    }

    public Link with(String title) {
        return new Link(this.rel, this.href, this.classes, this.type, Optional.of(title));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        if (!this.classes.equals(link.classes)) {
            return false;
        }
        if (!this.rel.equals(link.rel)) {
            return false;
        }
        if (!this.href.equals(link.href)) {
            return false;
        }
        if (!this.type.equals(link.type)) {
            return false;
        }
        return this.title.equals(link.title);
    }

    public int hashCode() {
        int result = this.classes.hashCode();
        result = 31 * result + this.rel.hashCode();
        result = 31 * result + this.href.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.title.hashCode();
        return result;
    }
}

