/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import no.arktekk.siren.Action;
import no.arktekk.siren.Actions;
import no.arktekk.siren.Classes;
import no.arktekk.siren.Entities;
import no.arktekk.siren.Entity;
import no.arktekk.siren.Field;
import no.arktekk.siren.Fields;
import no.arktekk.siren.Link;
import no.arktekk.siren.Links;
import no.arktekk.siren.MIMEType;
import no.arktekk.siren.Method;
import no.arktekk.siren.Rel;
import no.arktekk.siren.SirenParseException;
import no.arktekk.siren.SubEntity;

public interface JsonParser<T> {
    public Entity fromJson(T var1);

    public static final class JavaxJsonParser
    implements JsonParser<JsonObject> {
        @Override
        public Entity fromJson(JsonObject json) {
            return this.parseEntity(json);
        }

        private Entity parseEntity(JsonObject object) {
            Optional<Classes> classes = this.orEmpty(object, "class").map(cs -> new Classes(this.arrayToStringList((JsonArray)cs)));
            Optional<JsonObject> properties = Optional.ofNullable(object.getJsonObject("properties"));
            Optional<Entities> entities = this.orEmpty(object, "entities").map(es -> new Entities(this.mapObjectList((JsonArray)es, this::parseSubEntity)));
            Optional<Actions> actions = this.orEmpty(object, "actions").map(as -> new Actions(this.mapObjectList((JsonArray)as, this::parseAction)));
            Optional<Links> links = this.orEmpty(object, "links").map(ls -> new Links(this.mapObjectList((JsonArray)ls, this::parseLink)));
            return new Entity(classes, properties, entities, actions, links, this.parseTitle(object));
        }

        private Optional<String> parseTitle(JsonObject object) {
            return object.containsKey((Object)"title") ? Optional.of(object.getString("title")) : Optional.empty();
        }

        private Optional<String> get(JsonObject object, String key) {
            if (object.containsKey((Object)key)) {
                return Optional.ofNullable(object.getString(key));
            }
            return Optional.empty();
        }

        private Link parseLink(JsonObject obj) {
            URI href = this.getHref(obj, "Link");
            Rel rels = new Rel(this.arrayToStringList(obj.getJsonArray("rel")));
            if (rels.isEmpty()) {
                throw new SirenParseException(String.format("Empty 'rel' in Link '%s'", obj));
            }
            Optional<MIMEType> type = this.get(obj, "type").flatMap(MIMEType::parse);
            Optional<Classes> classes = this.orEmpty(obj, "class").map(cs -> new Classes(this.arrayToStringList((JsonArray)cs)));
            return new Link(rels, href, classes, type, this.parseTitle(obj));
        }

        private Action parseAction(JsonObject action) {
            String name = action.getString("name");
            if (name == null) {
                throw new SirenParseException(String.format("Missing required 'name' field in Action '%s", action));
            }
            URI href = this.getHref(action, "Action");
            Optional<Method> method = this.get(action, "method").map(Method::valueOf);
            Optional<MIMEType> type = this.get(action, "type").flatMap(MIMEType::parse);
            Optional<Fields> fields = this.orEmpty(action, "fields").map(fs -> new Fields(this.mapObjectList((JsonArray)fs, this::parseField)));
            Optional<Classes> classes = this.orEmpty(action, "class").map(cs -> new Classes(this.arrayToStringList((JsonArray)cs)));
            return new Action(name, href, classes, this.get(action, "title"), method, type, fields);
        }

        private SubEntity parseSubEntity(JsonObject entity) {
            if (entity.containsKey((Object)"href")) {
                return this.parseEmbeddedLink(entity);
            }
            return this.parseEmbeddedRepresentation(entity);
        }

        private SubEntity.EmbeddedLink parseEmbeddedLink(JsonObject embeddedLink) {
            Link link = this.parseLink(embeddedLink);
            return new SubEntity.EmbeddedLink(link.rel, link.href, link.classes, link.type, link.title);
        }

        private SubEntity.EmbeddedRepresentation parseEmbeddedRepresentation(JsonObject embeddedRepresentation) {
            Entity entity = this.parseEntity(embeddedRepresentation);
            Rel rel = new Rel(this.arrayToStringList(embeddedRepresentation.getJsonArray("rel")));
            return new SubEntity.EmbeddedRepresentation(rel, entity);
        }

        private Field parseField(JsonObject field) {
            String name = field.getString("name");
            if (name == null) {
                throw new SirenParseException(String.format("Missing required 'name' field in Field '%s", field));
            }
            Optional<Classes> classes = this.orEmpty(field, "class").map(cs -> new Classes(this.arrayToStringList((JsonArray)cs)));
            Field.Type type = Field.Type.fromString(field.getString("type", "text"));
            return new Field(name, type, classes, Optional.ofNullable(field.get((Object)"value")), this.get(field, "title"));
        }

        private URI getHref(JsonObject obj, String name) {
            String hrefString = obj.getString("href");
            if (hrefString == null) {
                throw new SirenParseException(String.format("Missing required 'href' field in %s '%s'", name, obj));
            }
            return URI.create(hrefString);
        }

        private <A> List<A> mapObjectList(JsonArray list, Function<JsonObject, A> f) {
            return this.arrayToObjectStream(list).map(f).collect(Collectors.toList());
        }

        private Optional<JsonArray> orEmpty(JsonObject object, String name) {
            return Optional.ofNullable(object.getJsonArray(name));
        }

        private List<String> arrayToStringList(JsonArray classes) {
            return classes.stream().filter(j -> j.getValueType() == JsonValue.ValueType.STRING).map(j -> ((JsonString)j).getString()).collect(Collectors.toList());
        }

        private Stream<JsonObject> arrayToObjectStream(JsonArray classes) {
            return classes.stream().filter(j -> j.getValueType() == JsonValue.ValueType.OBJECT).map(j -> (JsonObject)j);
        }
    }
}

