/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.util.Optional;
import javax.json.JsonObject;
import no.arktekk.siren.Actions;
import no.arktekk.siren.Classes;
import no.arktekk.siren.Entities;
import no.arktekk.siren.JsonSerializable;
import no.arktekk.siren.JsonSerializer;
import no.arktekk.siren.Links;

public final class Entity
implements JsonSerializable {
    public final Optional<Classes> classes;
    public final Optional<JsonObject> properties;
    public final Optional<Entities> entities;
    public final Optional<Actions> actions;
    public final Optional<Links> links;
    public final Optional<String> title;

    public Entity(Optional<Classes> classes, Optional<JsonObject> properties, Optional<Entities> entities, Optional<Actions> actions, Optional<Links> links, Optional<String> title) {
        this.classes = classes;
        this.properties = properties;
        this.entities = entities;
        this.actions = actions;
        this.links = links;
        this.title = title;
    }

    public static Entity of() {
        return new Entity(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Entity with(Classes classes) {
        return new Entity(Optional.of(classes), this.properties, this.entities, this.actions, this.links, this.title);
    }

    public Entity with(JsonObject properties) {
        return new Entity(this.classes, Optional.of(properties), this.entities, this.actions, this.links, this.title);
    }

    public Entity with(Entities entities) {
        return new Entity(this.classes, this.properties, Optional.of(entities), this.actions, this.links, this.title);
    }

    public Entity with(Actions actions) {
        return new Entity(this.classes, this.properties, this.entities, Optional.of(actions), this.links, this.title);
    }

    public Entity with(Links links) {
        return new Entity(this.classes, this.properties, this.entities, this.actions, Optional.of(links), this.title);
    }

    public Entity with(String title) {
        return new Entity(this.classes, this.properties, this.entities, this.actions, this.links, Optional.of(title));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        if (!this.classes.equals(entity.classes)) {
            return false;
        }
        if (!this.properties.equals(entity.properties)) {
            return false;
        }
        if (!this.entities.equals(entity.entities)) {
            return false;
        }
        if (!this.actions.equals(entity.actions)) {
            return false;
        }
        if (!this.links.equals(entity.links)) {
            return false;
        }
        return this.title.equals(entity.title);
    }

    public int hashCode() {
        int result = this.classes.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + this.entities.hashCode();
        result = 31 * result + this.actions.hashCode();
        result = 31 * result + this.links.hashCode();
        result = 31 * result + this.title.hashCode();
        return result;
    }

    @Override
    public <T> T toJson(JsonSerializer<T> serializer) {
        return serializer.serialize(this);
    }
}

