/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import no.arktekk.siren.util.StreamUtils;
import no.arktekk.siren.util.StreamableIterable;

public final class Classes
implements StreamableIterable<String> {
    private final List<String> classes;

    public Classes(Iterable<String> classes) {
        this.classes = Collections.unmodifiableList(StreamUtils.stream(classes).collect(Collectors.toList()));
    }

    public static Classes of(final String clazz, final String ... classes) {
        return new Classes((Iterable<String>)new ArrayList<String>(){
            {
                this.add(clazz);
                this.addAll(Arrays.asList(classes));
            }
        });
    }

    @Override
    public Iterator<String> iterator() {
        return this.classes.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classes strings = (Classes)o;
        return this.classes.equals(strings.classes);
    }

    public int hashCode() {
        return this.classes.hashCode();
    }
}

