/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import no.arktekk.siren.Classes;
import no.arktekk.siren.Fields;
import no.arktekk.siren.MIMEType;
import no.arktekk.siren.Method;
import no.arktekk.siren.field.FieldSerializer;
import no.arktekk.siren.field.WWWUrlEncodedFieldSerializer;

public final class Action {
    public final String name;
    public final URI href;
    public final Optional<Classes> classes;
    public final Optional<String> title;
    public final Optional<Method> method;
    public final Optional<MIMEType> type;
    public final Optional<Fields> fields;

    public Action(String name, URI href, Optional<Classes> classes, Optional<String> title, Optional<Method> method, Optional<MIMEType> type, Optional<Fields> fields) {
        this.name = Objects.requireNonNull(name, "name may not be null");
        this.href = Objects.requireNonNull(href, "href may not be null");
        this.classes = classes;
        this.title = title;
        this.method = method;
        this.type = type;
        this.fields = fields;
    }

    public static Action of(String name, URI href) {
        return new Action(name, href, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Action with(Classes classes) {
        return new Action(this.name, this.href, Optional.of(classes), this.title, this.method, this.type, this.fields);
    }

    public Action with(String title) {
        return new Action(this.name, this.href, this.classes, Optional.of(title), this.method, this.type, this.fields);
    }

    public Action with(Method method) {
        return new Action(this.name, this.href, this.classes, this.title, Optional.of(method), this.type, this.fields);
    }

    public Action with(MIMEType type) {
        return new Action(this.name, this.href, this.classes, this.title, this.method, Optional.of(type), this.fields);
    }

    public Action with(Fields fields) {
        return new Action(this.name, this.href, this.classes, this.title, this.method, this.type, Optional.of(fields));
    }

    public Optional<String> format(FieldSerializer serializer) {
        return serializer.serialize(this.type.orElse(MIMEType.URLEncoded), this.fields);
    }

    public Optional<String> format() {
        return this.format(WWWUrlEncodedFieldSerializer.INSTANCE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (!this.name.equals(action.name)) {
            return false;
        }
        if (!this.classes.equals(action.classes)) {
            return false;
        }
        if (!this.href.equals(action.href)) {
            return false;
        }
        if (!this.title.equals(action.title)) {
            return false;
        }
        if (!this.method.equals(action.method)) {
            return false;
        }
        if (!this.type.equals(action.type)) {
            return false;
        }
        return this.fields.equals(action.fields);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.classes.hashCode();
        result = 31 * result + this.href.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.fields.hashCode();
        return result;
    }
}

