/*
 * Decompiled with CFR 0.152.
 */
package nl.pdok.catalog.workbench;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.pdok.catalog.workbench.WorkbenchParameter;
import nl.pdok.catalog.workbench.WorkbenchResource;

public class Workbench
implements Serializable {
    private static final long serialVersionUID = 89987294789L;
    private String name;
    private File target;
    private List<WorkbenchParameter> parameters = new ArrayList<WorkbenchParameter>();
    private List<WorkbenchResource> resources = new ArrayList<WorkbenchResource>();

    public Workbench(String name, File target) {
        this.name = name;
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public List<WorkbenchParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(WorkbenchParameter parameter) {
        this.parameters.add(parameter);
    }

    public void addParameters(Collection<WorkbenchParameter> parameters) {
        this.parameters.addAll(parameters);
    }

    public List<WorkbenchResource> getResources() {
        return this.resources;
    }

    public WorkbenchResource getResource(String resourcename) {
        for (WorkbenchResource resource : this.resources) {
            if (!resource.getName().equals(resourcename)) continue;
            return resource;
        }
        return null;
    }

    public void addResource(WorkbenchResource resource) {
        this.resources.add(resource);
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.target);
    }

    public long getStreamLength() {
        return this.target.length();
    }

    public Workbench clone() {
        Workbench clone = new Workbench(this.name, null);
        for (WorkbenchParameter param : this.parameters) {
            clone.parameters.add(param.clone());
        }
        return clone;
    }
}

