/*
 * Decompiled with CFR 0.152.
 */
package nl.pdok.catalog;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nl.pdok.catalog.Catalog;
import nl.pdok.catalog.exceptions.ConfigurationException;
import nl.pdok.catalog.extract.ExtractConfiguration;
import nl.pdok.catalog.extract.ExtractConfigurationReader;
import nl.pdok.catalog.featured.FeatureTemplate;
import nl.pdok.catalog.featured.FeaturedCollectionOptions;
import nl.pdok.catalog.gitutil.GitInteractionsHandler;
import nl.pdok.catalog.job.JobConfiguration;
import nl.pdok.catalog.job.JobConfigurationDataset;
import nl.pdok.catalog.job.JobConfigurationReader;
import nl.pdok.catalog.jobentry.JobEntriesReader;
import nl.pdok.catalog.jobentry.JobEntry;
import nl.pdok.catalog.jobentry.JobEntryException;
import nl.pdok.catalog.testdata.TestData;
import nl.pdok.catalog.tiling.TilingConfiguration;
import nl.pdok.catalog.tiling.TilingConfigurationReader;
import nl.pdok.catalog.transformation.TransformationConfiguration;
import nl.pdok.catalog.transformation.TransformationConfigurationReader;
import nl.pdok.catalog.workbench.FmeWorkbenchEnvConfig;
import nl.pdok.catalog.workbench.Workbench;
import nl.pdok.catalog.workbench.WorkbenchParameter;
import nl.pdok.catalog.workbench.WorkbenchResource;
import nl.pdok.catalog.workbench.WorkbenchType;
import nl.pdok.util.ZipUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class FileSystemCatalog
implements Catalog {
    private static final String RESOURCE_EXTENSION = ".resources";
    private static final String PARAMETERS_EXTENSION = ".parameters";
    private static final String DDL_RESOURCE_EXTENSION = ".sql";
    protected static final String DDL_RESOURCE_FOLDER = "ddl";
    private static final String CSV_RESOURCE_FOLDER = "csv";
    private static final String SQL_RESOURCE_FOLDER = "sql";
    private static final String SHAPES_TO_DB_FOLDER = "shapesToDB";
    private static final String SHAPES_TO_FEATURED_FOLDER = "shapesToFeatured";
    private static final String MAPPROXY_FOLDER = "mapproxy";
    private static final String MAPPROXY_SERVICE = "mapproxy";
    private static final String MAPPROXY_SEED = "seed";
    private static final String MAPPROXY_CONFIG_EXTENSION = ".yaml";
    private static final String DATASETS_FOLDER = "datasets";
    private static final String TEST_FOLDER = "testset";
    private static final String TEST_DATA_FOLDER = "data";
    private static final String TEST_EXPECTED_FOLDER = "expected";
    private static final String TEST_PREPARE_FOLDER = "prepare";
    private static final String TEMPLATES_FOLDER = "templates";
    private static final String DICTIONARY_SEPARATION_CHAR = "=";
    private static final String SHARED_FOLDER = "shared";
    private static final String FILENAME_JOB_CONFIGURATION = "configuration.json";
    private static final String FILENAME_TILING_CONFIGURATION = "tiling.json";
    private static final String FILENAME_TRANSFORMATION_CONFIGURATION = "transformation.json";
    private static final String FILENAME_EXTRACT_CONFIGURATION = "extract.json";
    private static final String WORKBENCH_EXTENSION = ".fmw";
    private static final String WORKBENCH_FOLDER = "workbench";
    private static final String TEMPLATE_FOLDER = "templates";
    private static final String TEMPLATE_PARTIAL_FOLDER = "partials";
    private static final String XML2JSON_FOLDER = "xml2json";
    private static final String TRANSFORMERS = "transformers";
    private static final String TRANSFORMER_EXTENSION = ".fmx";
    private FmeWorkbenchEnvConfig fmeworkbenchenvconfig = null;
    private Path datasetsFolder;
    private Path catalogFolder;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemCatalog.class);

    public FileSystemCatalog(File catalogFolder, FmeWorkbenchEnvConfig fmeworkbenchenvconfig) {
        this(catalogFolder);
        this.fmeworkbenchenvconfig = fmeworkbenchenvconfig;
    }

    public FileSystemCatalog(File catalogFolder) {
        this.catalogFolder = catalogFolder.toPath();
        this.datasetsFolder = Paths.get(this.catalogFolder.toString(), DATASETS_FOLDER);
    }

    @Override
    public Collection<String> getDatasetNames() {
        ArrayList<String> datasetNames = new ArrayList<String>();
        try (DirectoryStream<Path> catalog = Files.newDirectoryStream(this.datasetsFolder, this.getFilterPathIsDirectory(true));){
            for (Path dataset : catalog) {
                datasetNames.add(dataset.getFileName().toString());
            }
        }
        catch (IOException ex) {
            LOGGER.trace(ex.getMessage(), (Throwable)ex);
        }
        return datasetNames;
    }

    @Override
    public List<Workbench> getWorkbenches(String datasetName) {
        LinkedList<Workbench> results = new LinkedList<Workbench>();
        File workbenchesFolder = this.workbenchesFolder(datasetName);
        if (!workbenchesFolder.exists() || !workbenchesFolder.isDirectory()) {
            return results;
        }
        for (WorkbenchType type : WorkbenchType.values()) {
            results.addAll(this.getWorkbenches(datasetName, type));
        }
        return results;
    }

    @Override
    public List<Workbench> getWorkbenches(String datasetName, WorkbenchType type) {
        LinkedList<Workbench> results = new LinkedList<Workbench>();
        File typedWorkbenchesFolder = this.typedWorkbenchesFolder(datasetName, type);
        if (!typedWorkbenchesFolder.exists() || !typedWorkbenchesFolder.isDirectory()) {
            return results;
        }
        File[] workbenches = typedWorkbenchesFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(FileSystemCatalog.WORKBENCH_EXTENSION);
            }
        });
        Arrays.sort(workbenches, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File workbenchFile : workbenches) {
            results.add(this.getWorkbench(datasetName, type, workbenchFile.getName()));
        }
        return results;
    }

    @Override
    public Workbench getWorkbench(String datasetName, WorkbenchType type, String workbenchName) {
        File workbenchFile = this.workbenchFile(datasetName, type, workbenchName);
        if (!workbenchFile.exists() || !workbenchFile.isFile()) {
            return null;
        }
        Workbench result = new Workbench(workbenchFile.getName(), workbenchFile);
        for (File resource : this.getResources(datasetName, type, workbenchName)) {
            result.addResource(new WorkbenchResource(resource.getName(), resource));
        }
        try {
            for (WorkbenchParameter parameter : this.getParameters(datasetName, type, workbenchName)) {
                result.addParameter(parameter);
            }
        }
        catch (IOException ex) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    @Override
    public List<Workbench> getTransformers() {
        File[] workbenches;
        LinkedList<Workbench> results = new LinkedList<Workbench>();
        File transformersFolder = Paths.get(this.catalogFolder.toString(), SHARED_FOLDER, TRANSFORMERS).toFile();
        if (!transformersFolder.exists() || !transformersFolder.isDirectory()) {
            return results;
        }
        for (File workbenchFile : workbenches = transformersFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(FileSystemCatalog.TRANSFORMER_EXTENSION);
            }
        })) {
            results.add(new Workbench(workbenchFile.getName(), workbenchFile));
        }
        return results;
    }

    private File workbenchesFolder(String datasetName) {
        return Paths.get(this.datasetsFolder.toString(), datasetName, WORKBENCH_FOLDER).toFile();
    }

    private File typedWorkbenchesFolder(String datasetName, WorkbenchType type) {
        return new File(this.workbenchesFolder(datasetName), type.toString().toLowerCase());
    }

    private File workbenchFile(String datasetName, WorkbenchType type, String workbenchName) {
        return new File(this.typedWorkbenchesFolder(datasetName, type), workbenchName);
    }

    private File[] getResources(String datasetName, WorkbenchType type, String workbenchName) {
        File typedWorkbenchesFolder = this.typedWorkbenchesFolder(datasetName, type);
        File resourceFolder = new File(typedWorkbenchesFolder, workbenchName + RESOURCE_EXTENSION);
        if (resourceFolder.exists() && resourceFolder.isDirectory()) {
            return resourceFolder.listFiles();
        }
        return new File[0];
    }

    private List<WorkbenchParameter> getParameters(String datasetName, WorkbenchType type, String workbenchName) throws IOException {
        LinkedList<WorkbenchParameter> results = new LinkedList<WorkbenchParameter>();
        File typedWorkbenchesFolder = this.typedWorkbenchesFolder(datasetName, type);
        File parametersFile = new File(typedWorkbenchesFolder, workbenchName + PARAMETERS_EXTENSION);
        if (parametersFile.exists() && parametersFile.isFile()) {
            List lines = FileUtils.readLines((File)parametersFile);
            for (String line : lines) {
                WorkbenchParameter parameter = this.getParameter(line);
                if (parameter == null) continue;
                results.add(parameter);
            }
        }
        for (WorkbenchParameter parameter : results) {
            if (!parameter.getValue().equals("*")) continue;
            for (WorkbenchParameter workbenchenvparameter : this.fmeworkbenchenvconfig.getParameters()) {
                if (!workbenchenvparameter.getName().equals(parameter.getName())) continue;
                parameter.setValue(workbenchenvparameter.getValue());
            }
        }
        return results;
    }

    private WorkbenchParameter getParameter(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        String[] splitted = line.split(DICTIONARY_SEPARATION_CHAR, 2);
        if (splitted.length <= 1 || splitted[1].isEmpty()) {
            return null;
        }
        return new WorkbenchParameter(splitted[0], splitted[1]);
    }

    @Override
    public String getServiceName(String datasetName) {
        return this.loadJobConfiguration(datasetName).getWorkspace();
    }

    @Override
    public String getGeoserverType(String datasetName) {
        return this.loadJobConfiguration(datasetName).getGeoserver();
    }

    @Override
    public String getTargetProjection(String datasetName) {
        return (String)this.getSingleDatasetProperty(datasetName, datasetName, "target_projection");
    }

    @Override
    public boolean isVersioned(String datasetName) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.getSingleDatasetProperty(datasetName, datasetName, "versioned")), (boolean)false);
    }

    @Override
    public boolean withIndexes(String datasetName) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.getSingleDatasetProperty(datasetName, datasetName, "withindexes")), (boolean)true);
    }

    @Override
    public boolean withGtPkMetadata(String datasetName) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.getSingleDatasetProperty(datasetName, datasetName, "withgtpkmetadata")), (boolean)true);
    }

    @Override
    public String getDatasetNameVersioned(String datasetName, long version) {
        return this.isVersioned(datasetName) ? datasetName + "_v" + version : datasetName;
    }

    @Override
    public Set<String> getVersionedSchemas(String datasetName, long version) {
        HashSet<String> schemas = new HashSet<String>();
        if (this.datasetExists(datasetName)) {
            JobConfiguration jobConfig = this.loadJobConfiguration(datasetName);
            for (JobConfigurationDataset dataset : jobConfig.getDatasets()) {
                if (dataset.getVersioned() == null || !dataset.getVersioned().booleanValue() || dataset.getDbSchema() == null) continue;
                schemas.add(dataset.getDbSchema() + "_v" + version);
            }
        }
        return schemas;
    }

    private Object getSingleDatasetProperty(final String workspaceName, final String datasetName, final String propertyName) {
        JobConfiguration jobConfig = this.loadJobConfiguration(workspaceName);
        Object res = null;
        if (jobConfig != null) {
            ImmutableList propertyInDatasetConfigs = FluentIterable.from(jobConfig.getDatasets()).filter((Predicate)new Predicate<JobConfigurationDataset>(){

                public boolean apply(JobConfigurationDataset t) {
                    return StringUtils.equals((CharSequence)t.getName(), (CharSequence)datasetName);
                }
            }).transform((Function)new Function<JobConfigurationDataset, Object>(){

                public Object apply(JobConfigurationDataset f) {
                    try {
                        return PropertyUtils.getProperty((Object)f, (String)propertyName);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                        String msg = FileSystemCatalog.this.buildPropertyExceptionMessage(f, propertyName, workspaceName, datasetName);
                        throw new IllegalStateException(msg, ex);
                    }
                }
            }).filter(Predicates.notNull()).toList();
            if (propertyInDatasetConfigs.size() > 1) {
                throw new IllegalStateException("Multiple values found for property " + propertyName + " in workspace " + workspaceName + " and dataset " + datasetName);
            }
            if (propertyInDatasetConfigs.size() == 1) {
                res = propertyInDatasetConfigs.get(0);
            }
        }
        return res;
    }

    private String buildPropertyExceptionMessage(JobConfigurationDataset f, String propertyName, String workspaceName, String datasetName) {
        ImmutableList properties = FluentIterable.from(Arrays.asList(BeanUtils.getPropertyDescriptors(f.getClass()))).transform((Function)new Function<PropertyDescriptor, String>(){

            public String apply(PropertyDescriptor f1) {
                return f1.getName();
            }
        }).toList();
        return "Property " + propertyName + "is not defined for dataset configuration in catalogus workspace " + workspaceName + ", " + datasetName + ". Available properties: " + Joiner.on((String)", ").join((Iterable)properties);
    }

    @Override
    public ArrayList<FeaturedCollectionOptions> getFeaturedOptions(String datasetName) {
        ArrayList<FeaturedCollectionOptions> collectionoptions = this.loadJobConfiguration(datasetName).getFeatured();
        if (collectionoptions == null) {
            collectionoptions = new ArrayList();
        }
        return collectionoptions;
    }

    private JobConfiguration loadJobConfiguration(String datasetName) {
        File configurationFile = Paths.get(this.datasetsFolder.toString(), datasetName, FILENAME_JOB_CONFIGURATION).toFile();
        return JobConfigurationReader.read(configurationFile, datasetName);
    }

    @Override
    public TilingConfiguration getTilingConfiguration(String datasetName) {
        File configurationFile = Paths.get(this.datasetsFolder.toString(), datasetName, FILENAME_TILING_CONFIGURATION).toFile();
        return TilingConfigurationReader.read(configurationFile, datasetName);
    }

    @Override
    public InputStream getMapProxyTemplate(String datasetName, String configFile) throws IOException {
        if ("mapproxy".equals(configFile.toLowerCase()) || MAPPROXY_SEED.equals(configFile.toLowerCase())) {
            File mapYaml = Paths.get(this.datasetsFolder.toString(), datasetName, "mapproxy", configFile + MAPPROXY_CONFIG_EXTENSION).toFile();
            return new FileInputStream(mapYaml);
        }
        LOGGER.warn("no mapproxy configfile found with the name: " + configFile);
        throw new RuntimeException();
    }

    @Override
    public ExtractConfiguration getExtractConfiguration(String datasetName) {
        File configurationFile = Paths.get(this.datasetsFolder.toString(), datasetName, FILENAME_EXTRACT_CONFIGURATION).toFile();
        return ExtractConfigurationReader.read(configurationFile, datasetName);
    }

    @Override
    public List<JobConfigurationDataset> getDatastoresConfiguration(String datasetName) {
        return this.loadJobConfiguration(datasetName).getDatasets();
    }

    @Override
    public Set<String> getExtractTypes(String datasetName) throws IOException {
        HashSet<String> res = new HashSet<String>();
        Path templateFolder = Paths.get(this.datasetsFolder.toString(), datasetName, "templates");
        if (Files.isDirectory(templateFolder, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(templateFolder);){
                for (Path entry : stream) {
                    if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                    res.add(entry.getFileName().toString());
                }
            }
        }
        return res;
    }

    @Override
    public Set<FeatureTemplate> getFeatureTemplates(String datasetName) throws IOException {
        HashSet<FeatureTemplate> res = new HashSet<FeatureTemplate>();
        for (String extractType : this.getExtractTypes(datasetName)) {
            Path entry = Paths.get(this.datasetsFolder.toString(), datasetName, "templates", extractType);
            res.add(this.getFeatureTemplateExtractType(entry));
        }
        return res;
    }

    private FeatureTemplate getFeatureTemplateExtractType(Path extractTypeFolder) throws IOException {
        FeatureTemplate res = new FeatureTemplate(extractTypeFolder.getFileName().toString());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extractTypeFolder);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0]) && StringUtils.equals((CharSequence)TEMPLATE_PARTIAL_FOLDER, (CharSequence)entry.getFileName().toString())) {
                    this.getFeatureTemplatePartials(entry, res);
                    continue;
                }
                if (!Files.isRegularFile(entry, new LinkOption[0])) continue;
                res.addFeature(entry);
            }
        }
        return res;
    }

    private void getFeatureTemplatePartials(Path extractTypeFolder, FeatureTemplate res) throws IOException {
        try (DirectoryStream<Path> partialsStream = Files.newDirectoryStream(extractTypeFolder);){
            for (Path partialEntry : partialsStream) {
                if (!Files.isRegularFile(partialEntry, new LinkOption[0])) continue;
                res.addPartialFeature(partialEntry);
            }
        }
    }

    @Override
    public String getXml2JsonMapping(String datasetName, String translator) throws IOException {
        Path xml2jsonFolder = Paths.get(this.datasetsFolder.toString(), datasetName, XML2JSON_FOLDER);
        if (!Files.exists(xml2jsonFolder, new LinkOption[0])) {
            throw new IllegalStateException("XML2JSON_FOLDER not found at " + xml2jsonFolder);
        }
        StringBuilder resultBuilder = new StringBuilder();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(xml2jsonFolder);){
            for (Path path : stream) {
                if (!path.getFileName().toString().toLowerCase().contains(translator)) continue;
                String body = new String(Files.readAllBytes(path));
                resultBuilder.append(body);
                LOGGER.debug("{} read as xml2json file", (Object)path);
                break;
            }
        }
        String result = resultBuilder.toString();
        LOGGER.debug("Using xml2json mapping: {}", (Object)result);
        return result;
    }

    @Override
    public String getEngineTransformJson(String datasetName, String defaultEngine) throws ConfigurationException {
        File transformFile = Paths.get(this.datasetsFolder.toString(), datasetName, FILENAME_TRANSFORMATION_CONFIGURATION).toFile();
        if (!transformFile.exists()) {
            return defaultEngine;
        }
        TransformationConfiguration configuration = TransformationConfigurationReader.read(datasetName, transformFile);
        String engine = configuration.getEngine();
        if (engine == null) {
            throw new ConfigurationException("Configuration-item 'engine' for dataset " + datasetName + " is empty");
        }
        return configuration.getEngine();
    }

    @Override
    public String getRootLocation() {
        return this.catalogFolder.toString();
    }

    protected DirectoryStream.Filter<Path> getFilterPathIsDirectory(final boolean isDirectory) {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory(entry, new LinkOption[0]) == isDirectory;
            }
        };
    }

    @Override
    public List<TestData> getDatasetTestData(String datasetName) {
        Path testDataFolder = this.getDatasetLocationTestData(datasetName);
        ArrayList<TestData> results = new ArrayList<TestData>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(testDataFolder, this.getFilterPathIsDirectory(false));){
            for (Path testDataFile : ds) {
                boolean zipped = ZipUtils.isZip((File)testDataFile.toFile());
                results.add(new TestData(testDataFile.getFileName().toString(), new FileInputStream(testDataFile.toFile()), zipped));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return results;
    }

    @Override
    public Path getDatasetLocationTest(String datasetName) {
        return Paths.get(this.datasetsFolder.toString(), datasetName, TEST_FOLDER);
    }

    @Override
    public Path getDatasetLocationTestData(String datasetName) {
        return Paths.get(this.getDatasetLocationTest(datasetName).toString(), TEST_DATA_FOLDER);
    }

    @Override
    public Path getDatasetLocationTestExpected(String datasetName) {
        return Paths.get(this.getDatasetLocationTest(datasetName).toString(), TEST_EXPECTED_FOLDER);
    }

    @Override
    public Path getDatasetLocationShapesToDB(String datasetName) {
        return Paths.get(this.datasetsFolder.toString(), datasetName, SHAPES_TO_DB_FOLDER);
    }

    @Override
    public Path getDatasetLocationShapesToFeatured(String datasetName) {
        return Paths.get(this.datasetsFolder.toString(), datasetName, SHAPES_TO_FEATURED_FOLDER);
    }

    @Override
    public Path getDatasetLocationTemplatesPath(String dataset) {
        return Paths.get(this.datasetsFolder.toString(), dataset, "templates");
    }

    @Override
    public File getTemplateResource(String dataset, String format, String file, String subfolder) {
        if (subfolder.isEmpty()) {
            return Paths.get(this.getDatasetLocationTemplatesPath(dataset).toString(), format, file).toFile();
        }
        return Paths.get(this.getDatasetLocationTemplatesPath(dataset).toString(), format, subfolder, file).toFile();
    }

    @Override
    public InputStream getDdlResource(String datasetName) throws IOException {
        File ddlResourceFile = Paths.get(this.datasetsFolder.toString(), datasetName, DDL_RESOURCE_FOLDER, datasetName + DDL_RESOURCE_EXTENSION).toFile();
        return new FileInputStream(ddlResourceFile);
    }

    @Override
    public InputStream getSqlResource(String datasetName, String fileName) throws IOException {
        File sqlResourceFile = Paths.get(this.datasetsFolder.toString(), datasetName, SQL_RESOURCE_FOLDER, fileName).toFile();
        return new FileInputStream(sqlResourceFile);
    }

    @Override
    public InputStream getCsvResource(String datasetName, String fileName) throws IOException {
        File csvResourceFile = Paths.get(this.datasetsFolder.toString(), datasetName, CSV_RESOURCE_FOLDER, fileName).toFile();
        return new FileInputStream(csvResourceFile);
    }

    @Override
    public boolean datasetExists(String datasetName) {
        File datasetFolder = Paths.get(this.datasetsFolder.toString(), datasetName).toFile();
        return datasetFolder.exists();
    }

    @Override
    public InputStream getResourcePrepareTestset(String datasetName, String resourceName) throws IOException {
        File prepareTestsetFile = Paths.get(this.datasetsFolder.toString(), datasetName, TEST_FOLDER, TEST_PREPARE_FOLDER, resourceName).toFile();
        return new FileInputStream(prepareTestsetFile);
    }

    public static String getWorkbenchExtension() {
        return WORKBENCH_EXTENSION;
    }

    @Override
    public List<JobEntry> retrieveJobEntriesByDataset(String dataset) throws JobEntryException {
        return JobEntriesReader.retrieveJobEntriesByDatasetFromCatalogus(this.catalogFolder.toFile(), dataset);
    }

    @Override
    public boolean checkout(String gitAddress, String branchName, String authorization) {
        return GitInteractionsHandler.checkout(gitAddress, branchName, this.catalogFolder.toFile(), authorization);
    }

    @Override
    public boolean isCatalogusBranchPresent() {
        return GitInteractionsHandler.isCatalogusPresent(this.catalogFolder.toFile());
    }

    @Override
    public String checkCatalogusBranch() {
        return GitInteractionsHandler.whichBranchIsPresent(this.catalogFolder.toFile());
    }
}

