/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.postgres;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="docker.postgres", ignoreUnknownFields=false)
public class DockerPostgresProperties {
    private boolean enabled = true;
    private String stdOutFilename = "docker-std-out.log";
    private String stdErrFilename = "docker-std-err.log";
    private String password = "postgres";
    private Integer port = 5432;
    private String imageName = "postgres";
    private String imageVersion = "latest";
    private String containerName = "postgression";
    private String startupVerificationText = "PostgreSQL init process complete; ready for start up.";
    private String dockerCommand = "docker run --rm -e POSTGRES_PASSWORD=${password} -p ${port}:5432 --name ${containerName} ${imageName}:${imageVersion}";
    private Integer timeout = 300000;
    private boolean forceClean = false;
    private Map<String, String> customVariables = new HashMap<String, String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getStdOutFilename() {
        return this.stdOutFilename;
    }

    public void setStdOutFilename(String stdOutFilename) {
        this.stdOutFilename = stdOutFilename;
    }

    public String getStdErrFilename() {
        return this.stdErrFilename;
    }

    public void setStdErrFilename(String stdErrFilename) {
        this.stdErrFilename = stdErrFilename;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getImageVersion() {
        return this.imageVersion;
    }

    public void setImageVersion(String imageVersion) {
        this.imageVersion = imageVersion;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getStartupVerificationText() {
        return this.startupVerificationText;
    }

    public void setStartupVerificationText(String startupVerificationText) {
        this.startupVerificationText = startupVerificationText;
    }

    public String getDockerCommand() {
        return this.dockerCommand;
    }

    public void setDockerCommand(String dockerCommand) {
        this.dockerCommand = dockerCommand;
    }

    public boolean isForceClean() {
        return this.forceClean;
    }

    public void setForceClean(boolean forceClean) {
        this.forceClean = forceClean;
    }

    public Map<String, String> getCustomVariables() {
        return this.customVariables;
    }

    public void setCustomVariables(Map<String, String> customVariables) {
        this.customVariables = customVariables;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("stdOutFilename", this.getStdOutFilename());
        properties.put("stdErrFilename", this.getStdErrFilename());
        properties.put("timeout", this.getTimeout().toString());
        properties.put("password", this.getPassword());
        properties.put("port", this.getPort().toString());
        properties.put("containerName", this.getContainerName());
        properties.put("imageName", this.getImageName());
        properties.put("imageVersion", this.getImageVersion());
        properties.put("startupVerificationText", this.getStartupVerificationText());
        properties.put("dockerCommand", this.getDockerCommand());
        properties.put("forceClean", Boolean.toString(this.isForceClean()));
        properties.putAll(this.getCustomVariables());
        return properties;
    }
}

