/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.postgres;

import java.io.IOException;
import nl._42.boot.docker.postgres.DockerAvailableCheck;
import nl._42.boot.docker.postgres.DockerContainerAvailableCheck;
import nl._42.boot.docker.postgres.DockerForceRemoveContainer;
import nl._42.boot.docker.postgres.DockerImageAvailableCheck;
import nl._42.boot.docker.postgres.DockerPostgresContainer;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerPostgresBootSequence {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerPostgresBootSequence.class);
    private final DockerPostgresProperties properties;

    public DockerPostgresBootSequence(DockerPostgresProperties properties) {
        this.properties = properties;
    }

    public DockerPostgresContainer execute() throws IOException {
        LOGGER.info("| Docker Postgres Properties");
        LOGGER.info("| * Image name: " + this.properties.getImageName());
        LOGGER.info("| * Image version: " + this.properties.getImageVersion());
        LOGGER.info("| * Force clean: " + this.properties.isForceClean());
        LOGGER.info("| * Timeout: " + this.properties.getTimeout());
        LOGGER.info("| * Container name: " + this.properties.getContainerName());
        LOGGER.info("| * Port: " + this.properties.getPort());
        LOGGER.info("| * Password: " + this.properties.getPassword());
        LOGGER.info("| * Startup Verification Text: [" + this.properties.getStartupVerificationText() + "]");
        LOGGER.info("| * Docker command: [" + this.properties.getDockerCommand() + "]");
        LOGGER.info("| * Custom variables (" + this.properties.getCustomVariables().size() + ")");
        for (String key : this.properties.getCustomVariables().keySet()) {
            LOGGER.info("|   - " + key + ": " + this.properties.getCustomVariables().get(key));
        }
        LOGGER.info("| * Std out: " + this.properties.getStdOutFilename());
        LOGGER.info("| * Std err: " + this.properties.getStdErrFilename());
        new DockerAvailableCheck(this.properties).tryDocker();
        if (this.properties.isForceClean() && new DockerContainerAvailableCheck(this.properties).hasContainer()) {
            new DockerForceRemoveContainer(this.properties).forceRemove();
        }
        boolean imageDownloaded = new DockerImageAvailableCheck(this.properties).hasImage();
        DockerPostgresContainer postgresContainer = new DockerPostgresContainer(this.properties, imageDownloaded);
        postgresContainer.start();
        if (!postgresContainer.verify()) {
            LOGGER.error("| Postgres failed to initialize");
            throw new ExceptionInInitializerError("The Docker Container failed to properly initialize.");
        }
        LOGGER.info("| Postgres container successfully started");
        return postgresContainer;
    }
}

