/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.InvocationContextFactory;
import com.meterware.servletunit.ServletTestCase;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;

public abstract class JUnitServlet
extends HttpServlet {
    private InvocationContextFactory _factory;

    protected JUnitServlet(InvocationContextFactory factory) {
        this._factory = factory;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String testName = request.getParameter("test");
        if (testName == null || testName.length() == 0) {
            this.reportCannotRunTest(response.getWriter(), "No test class specified");
        } else {
            ServletTestRunner runner = new ServletTestRunner(testName, response.getWriter());
        }
        response.getWriter().close();
    }

    private void reportCannotRunTest(PrintWriter writer, String errorMessage) {
        writer.print("<html><head><title>Cannot run test</title></head><body>" + errorMessage + "</body></html>");
    }

    class ServletTestRunner
    extends BaseTestRunner {
        private String _elapsedTime;
        private PrintWriter _writer;
        private static final char LF = '\n';
        private static final char CR = '\r';
        private TestResult _testResult;
        private String _testClassName;

        public ServletTestRunner(String testClassName, PrintWriter writer) {
            this._writer = writer;
            this._testClassName = testClassName;
            Test suite = this.getTest(testClassName);
            ServletTestCase.setInvocationContextFactory(JUnitServlet.this._factory);
            if (suite != null) {
                this._testResult = new TestResult();
                this._testResult.addListener((TestListener)this);
                long startTime = System.currentTimeMillis();
                suite.run(this._testResult);
                long endTime = System.currentTimeMillis();
                this._elapsedTime = this.elapsedTimeAsString(endTime - startTime);
                this.displayResults(this._writer);
            }
        }

        public void addError(Test test, Throwable throwable) {
        }

        public void addFailure(Test test, AssertionFailedError error) {
        }

        public void endTest(Test test) {
        }

        protected void runFailed(String s) {
            JUnitServlet.this.reportCannotRunTest(this._writer, s);
        }

        public void startTest(Test test) {
        }

        public void testStarted(String s) {
        }

        public void testEnded(String s) {
        }

        public void testFailed(int i, Test test, Throwable throwable) {
        }

        public TestSuiteLoader getLoader() {
            return new StandardTestSuiteLoader();
        }

        void displayResults(PrintWriter writer) {
            writer.println("<html><head><title>Test Suite: " + this._testClassName + "</title>");
            writer.println("<style type='text/css'>");
            writer.println("<!--");
            writer.println("  td.detail { font-size:smaller; vertical-align: top }");
            writer.println("  -->");
            writer.println("</style></head><body>");
            writer.println("<table id='results' border='1'><tr>");
            writer.println("<td>" + this.getFormatted(this._testResult.runCount(), "test") + "</td>");
            writer.println("<td>Time: " + this._elapsedTime + "</td>");
            if (this._testResult.wasSuccessful()) {
                writer.println("<td>OK</td></tr>");
            } else {
                writer.println("<td>Problems Occurred</td></tr>");
                this.displayProblems(writer, "failure", this._testResult.failureCount(), this._testResult.failures());
                this.displayProblems(writer, "error", this._testResult.errorCount(), this._testResult.errors());
            }
            writer.println("</table>");
            writer.println("</body></html>");
        }

        private void displayProblems(PrintWriter writer, String title, int count, Enumeration enumeration) {
            if (count != 0) {
                writer.println("<tr><td colspan=3>" + this.getFormatted(count, title) + "</td></tr>");
                Enumeration e = enumeration;
                int i = 1;
                while (e.hasMoreElements()) {
                    TestFailure failure = (TestFailure)e.nextElement();
                    writer.println("<tr><td class='detail' align='right'>" + i + "</td>");
                    writer.println("<td class='detail'>" + failure.failedTest() + "</td><td class='detail'>");
                    if (failure.thrownException() instanceof AssertionFailedError) {
                        writer.println(this.htmlEscape(failure.thrownException().getMessage()));
                    } else {
                        writer.println(this.htmlEscape(BaseTestRunner.getFilteredTrace((Throwable)failure.thrownException())));
                    }
                    writer.println("</td></tr>");
                    ++i;
                }
            }
        }

        private String getFormatted(int count, String name) {
            return count + " " + name + (count == 1 ? "" : "s");
        }

        private String htmlEscape(String s) {
            StringBuffer result = new StringBuffer(s.length());
            char[] chars = s.toCharArray();
            int i = 0;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    case '>': {
                        result.append("&gt;");
                        break;
                    }
                    case '\n': {
                        if (i > 0 && chars[i - 1] == '\r') {
                            result.append(chars[i]);
                            break;
                        }
                    }
                    case '\r': {
                        result.append("<br>");
                    }
                    default: {
                        result.append(chars[i]);
                    }
                }
                ++i;
            }
            return result.toString();
        }

        static {
            LF = (char)10;
            CR = (char)13;
        }
    }
}

