/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.BasicAuthenticationRequiredException;
import com.meterware.servletunit.DispatchedRequestWrapper;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.RequestDispatcherImpl;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import com.meterware.servletunit.ServletUnitHttpRequest;
import com.meterware.servletunit.ServletUnitHttpResponse;
import com.meterware.servletunit.ServletUnitHttpSession;
import com.meterware.servletunit.ServletUnitWebResponse;
import com.meterware.servletunit.WebApplication;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class InvocationContextImpl
implements InvocationContext {
    private static final Cookie[] NO_COOKIES = new Cookie[0];
    private ServletUnitClient _client;
    private WebApplication _application;
    private HttpServletRequest _request;
    private ServletUnitHttpResponse _response = new ServletUnitHttpResponse();
    private URL _requestURL;
    private Stack _servletStack = new Stack();
    private String _target;
    private Servlet _servlet;
    private WebResponse _webResponse;

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    public Servlet getServlet() throws ServletException {
        if (this._servlet == null) {
            if (!this._application.requiresAuthorization(this._requestURL) || this.userIsAuthorized()) {
                this._servlet = this._application.getServletRequest(this._requestURL).getServlet();
            } else {
                if (this._request.getRemoteUser() != null) {
                    throw new AccessDeniedException(this._requestURL);
                }
                if (this._application.usesBasicAuthentication()) {
                    throw new BasicAuthenticationRequiredException(this._application.getAuthenticationRealm());
                }
                if (this._application.usesFormAuthentication()) {
                    this._servlet = this._application.getServletRequest(this._application.getLoginURL()).getServlet();
                    ((ServletUnitHttpRequest)this.getRequest()).setOriginalURL(this._requestURL);
                } else {
                    throw new IllegalStateException("Authorization required but no authentication method defined");
                }
            }
        }
        return this._servlet;
    }

    public WebResponse getServletResponse() throws IOException {
        if (this._webResponse == null) {
            HttpSession session = this._request.getSession(false);
            if (session != null && session.isNew()) {
                Cookie cookie = new Cookie("JSESSION", session.getId());
                cookie.setPath(this._application.getContextPath());
                this._response.addCookie(cookie);
            }
            this._webResponse = new ServletUnitWebResponse(this._client, this._target, this._requestURL, this._response);
        }
        return this._webResponse;
    }

    public String getTarget() {
        return this._target;
    }

    public void pushIncludeRequest(RequestDispatcher rd, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this._servlet == null) {
            throw new IllegalStateException("Get the servlet for this context before pushing a request");
        }
        this._request = DispatchedRequestWrapper.createIncludeRequestWrapper(request, rd);
        this._servletStack.push(this._servlet);
        this._servlet = ((RequestDispatcherImpl)rd).getServletMetaData().getServlet();
    }

    public void pushForwardRequest(RequestDispatcher rd, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this._servlet == null) {
            throw new IllegalStateException("Get the servlet for this context before pushing a request");
        }
        this._request = DispatchedRequestWrapper.createForwardRequestWrapper(request, rd);
        this._servletStack.push(this._servlet);
        this._servlet = ((RequestDispatcherImpl)rd).getServletMetaData().getServlet();
    }

    public void popRequest() {
        if (!(this._request instanceof DispatchedRequestWrapper)) {
            throw new IllegalStateException("May not pop the initial request");
        }
        this._request = ((DispatchedRequestWrapper)this._request).getBaseRequest();
        this._servlet = (Servlet)this._servletStack.pop();
    }

    private boolean userIsAuthorized() {
        String[] roles = this._application.getPermittedRoles(this._requestURL);
        int i = 0;
        while (i < roles.length) {
            if (this._request.isUserInRole(roles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    InvocationContextImpl(ServletUnitClient client, ServletRunner runner, String target, WebRequest request, Dictionary clientHeaders, byte[] messageBody) throws IOException, MalformedURLException {
        this._client = client;
        this._application = runner.getApplication();
        this._requestURL = request.getURL();
        this._target = target;
        ServletUnitHttpRequest suhr = new ServletUnitHttpRequest(this._application.getServletRequest(this._requestURL), request, runner.getContext(), clientHeaders, messageBody);
        this._request = suhr;
        Cookie[] cookies = this.getCookies(clientHeaders);
        int i = 0;
        while (i < cookies.length) {
            suhr.addCookie(cookies[i]);
            ++i;
        }
        if (this._application.usesBasicAuthentication()) {
            suhr.readBasicAuthentication();
        } else if (this._application.usesFormAuthentication()) {
            suhr.readFormAuthentication();
        }
        HttpSession session = this._request.getSession(false);
        if (session != null) {
            ((ServletUnitHttpSession)session).access();
        }
    }

    private Cookie[] getCookies(Dictionary clientHeaders) {
        String cookieHeader = (String)clientHeaders.get("Cookie");
        if (cookieHeader == null) {
            return NO_COOKIES;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        StringTokenizer st = new StringTokenizer(cookieHeader, "=;");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken();
            cookies.add(new Cookie(name, value));
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    class AccessDeniedException
    extends HttpException {
        public AccessDeniedException(URL baseURL) {
            super(403, "Access Denied", baseURL);
        }
    }
}

