/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.DOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;

class ScriptFilter
extends DefaultFilter {
    protected static final String SCRIPT_TYPE = "javascript";
    private HTMLConfiguration _configuration;
    private StringBuffer _activeScriptBlock;
    private String _systemID = "";
    private int _scriptIndex;
    private DOMParser _domParser;

    ScriptFilter(HTMLConfiguration config) {
        this._configuration = config;
    }

    public void setParser(DOMParser domParser) {
        this._domParser = domParser;
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this._activeScriptBlock = null;
        this._systemID = locator == null ? "" : locator.getLiteralSystemId() + "_";
        this._scriptIndex = 0;
        super.startDocument(locator, encoding, augs);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (!this.isSupportedScript(element, attrs)) {
            super.startElement(element, attrs, augs);
        } else {
            this._activeScriptBlock = new StringBuffer();
            String srcAttribute = attrs.getValue("src");
            if (srcAttribute != null) {
                this._activeScriptBlock.append(this._domParser.getIncludedScript(srcAttribute));
            }
        }
    }

    private boolean isSupportedScript(QName element, XMLAttributes attrs) {
        if (!element.rawname.equalsIgnoreCase("script") || attrs == null) {
            return false;
        }
        String value = attrs.getValue("language");
        return value == null || value.toLowerCase().startsWith(SCRIPT_TYPE);
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (!this.isSupportedScript(element, attrs)) {
            super.emptyElement(element, attrs, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this._activeScriptBlock != null) {
            this._activeScriptBlock.append(text.ch, text.offset, text.length);
        } else {
            super.characters(text, augs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this._activeScriptBlock == null) {
            super.endElement(element, augs);
        } else {
            try {
                try {
                    String scriptText = this._activeScriptBlock.toString();
                    String replacementText = this.getTranslatedScript(scriptText);
                    this._configuration.pushInputSource(this.newInputSource(replacementText));
                }
                catch (IOException e) {
                    Object var6_7 = null;
                    this._activeScriptBlock = null;
                }
                Object var6_6 = null;
                this._activeScriptBlock = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this._activeScriptBlock = null;
                throw throwable;
            }
        }
    }

    private XMLInputSource newInputSource(String replacementText) {
        StringBuffer systemID = new StringBuffer(this._systemID);
        systemID.append("script").append(++this._scriptIndex);
        return new XMLInputSource(null, systemID.toString(), null, (Reader)new StringReader(replacementText), "UTF-8");
    }

    protected String getTranslatedScript(String scriptText) throws IOException {
        return this._domParser.getScriptableDelegate().runScript(scriptText);
    }

    static {
        SCRIPT_TYPE = SCRIPT_TYPE;
    }
}

