/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.DefaultWebResponse;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLPage;
import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.HttpWebResponse;
import com.meterware.httpunit.NoSuchFrameException;
import com.meterware.httpunit.NotHTMLException;
import com.meterware.httpunit.WebApplet;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebTable;
import com.meterware.httpunit.WebWindow;
import com.meterware.httpunit.cookies.CookieJar;
import com.meterware.httpunit.cookies.CookieSource;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebResponse
implements HTMLSegment,
CookieSource {
    private String _refreshHeader;
    private boolean _hasSubframes;
    private URL _baseURL;
    private String _baseTarget;
    private boolean _parsingPage;
    static final String BLANK_HTML = "";
    static final WebResponse BLANK_RESPONSE;
    private static final String HTML_CONTENT = "text/html";
    private static final int UNINITIALIZED_INT = -2;
    private WebWindow _window;
    private HTMLPage _page;
    private String _contentHeader;
    private int _contentLength = -2;
    private String _contentType;
    private String _characterSet;
    private WebRequest _refreshRequest;
    private int _refreshDelay = -1;
    private String _responseText;
    private InputStream _inputStream;
    private URL _pageURL;
    private String _frameName;
    private WebClient _client;
    private Scriptable _scriptable;
    private CookieJar _cookies;
    private static String _defaultEncoding;
    private static final String[] DEFAULT_ENCODING_CANDIDATES;

    public static WebResponse newResponse(URLConnection connection) throws IOException {
        return new HttpWebResponse(null, "_top", connection.getURL(), connection, HttpUnitOptions.getExceptionsThrownOnErrorStatus());
    }

    public boolean isHTML() {
        return this.getContentType().equalsIgnoreCase(HTML_CONTENT);
    }

    public URL getURL() {
        return this._pageURL;
    }

    public String getTitle() throws SAXException {
        return this.getReceivedPage().getTitle();
    }

    public String getExternalStyleSheet() throws SAXException {
        return this.getReceivedPage().getExternalStyleSheet();
    }

    public String[] getMetaTagContent(String attribute, String attributeValue) throws SAXException {
        return this.getReceivedPage().getMetaTagContent(attribute, attributeValue);
    }

    public String getFrameName() {
        return this._frameName;
    }

    public WebRequest getRefreshRequest() {
        this.readRefreshRequest();
        return this._refreshRequest;
    }

    public int getRefreshDelay() {
        this.readRefreshRequest();
        return this._refreshDelay;
    }

    public abstract int getResponseCode();

    public abstract String getResponseMessage();

    public int getContentLength() {
        if (this._contentLength == -2) {
            String length = this.getHeaderField("Content-Length");
            this._contentLength = length == null ? -1 : Integer.parseInt(length);
        }
        return this._contentLength;
    }

    public String getContentType() {
        if (this._contentType == null) {
            this.readContentTypeHeader();
        }
        return this._contentType;
    }

    public String getCharacterSet() {
        if (this._characterSet == null) {
            this.readContentTypeHeader();
            if (this._characterSet == null) {
                this.setCharacterSet(this.getHeaderField("Charset"));
            }
            if (this._characterSet == null) {
                this.setCharacterSet(HttpUnitOptions.getDefaultCharacterSet());
            }
        }
        return this._characterSet;
    }

    public String[] getNewCookieNames() {
        return this.getCookieJar().getCookieNames();
    }

    public String getNewCookieValue(String name) {
        return this.getCookieJar().getCookieValue(name);
    }

    public abstract String[] getHeaderFieldNames();

    public abstract String getHeaderField(String var1);

    public String getText() throws IOException {
        if (this._responseText == null) {
            this.loadResponseText();
        }
        return this._responseText;
    }

    public InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new ByteArrayInputStream(this.getText().getBytes());
        }
        return this._inputStream;
    }

    public String[] getFrameNames() throws SAXException {
        WebFrame[] frames = this.getFrames();
        String[] result = new String[frames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = frames[i].getFrameName();
            ++i;
        }
        return result;
    }

    public WebResponse getSubframeContents(String subFrameName) {
        if (this._window == null) {
            throw new NoSuchFrameException(subFrameName);
        }
        return this._window.getFrameContents(WebFrame.getNestedFrameName(this._frameName, subFrameName));
    }

    public HTMLElement getElementWithID(String id) throws SAXException {
        return this.getReceivedPage().getElementWithID(id);
    }

    public WebForm[] getForms() throws SAXException {
        return this.getReceivedPage().getForms();
    }

    public WebForm getFormWithName(String name) throws SAXException {
        return this.getReceivedPage().getFormWithName(name);
    }

    public WebForm getFormWithID(String ID) throws SAXException {
        return this.getReceivedPage().getFormWithID(ID);
    }

    public WebLink[] getLinks() throws SAXException {
        return this.getReceivedPage().getLinks();
    }

    public WebLink getLinkWith(String text) throws SAXException {
        return this.getReceivedPage().getLinkWith(text);
    }

    public WebLink getLinkWithImageText(String text) throws SAXException {
        return this.getReceivedPage().getLinkWithImageText(text);
    }

    public WebLink getLinkWithName(String name) throws SAXException {
        return this.getReceivedPage().getLinkWithName(name);
    }

    public WebLink getLinkWithID(String ID) throws SAXException {
        return this.getReceivedPage().getLinkWithID(ID);
    }

    public WebLink getFirstMatchingLink(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getFirstMatchingLink(predicate, criteria);
    }

    public WebLink[] getMatchingLinks(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getMatchingLinks(predicate, criteria);
    }

    public WebImage[] getImages() throws SAXException {
        return this.getReceivedPage().getImages();
    }

    public WebImage getImageWithName(String source) throws SAXException {
        return this.getReceivedPage().getImageWithName(source);
    }

    public WebImage getImageWithSource(String source) throws SAXException {
        return this.getReceivedPage().getImageWithSource(source);
    }

    public WebImage getImageWithAltText(String altText) throws SAXException {
        return this.getReceivedPage().getImageWithAltText(altText);
    }

    public WebApplet[] getApplets() throws SAXException {
        return this.getReceivedPage().getApplets();
    }

    public Document getDOM() throws SAXException {
        if (this.isHTML()) {
            return (Document)this.getReceivedPage().getDOM();
        }
        try {
            return HttpUnitUtils.newParser().parse(new InputSource(new StringReader(this.getText())));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public WebTable[] getTables() throws SAXException {
        return this.getReceivedPage().getTables();
    }

    public WebTable getFirstMatchingTable(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getFirstMatchingTable(predicate, criteria);
    }

    public WebTable getTableStartingWith(String text) throws SAXException {
        return this.getReceivedPage().getTableStartingWith(text);
    }

    public WebTable getTableStartingWithPrefix(String text) throws SAXException {
        return this.getReceivedPage().getTableStartingWithPrefix(text);
    }

    public WebTable getTableWithSummary(String text) throws SAXException {
        return this.getReceivedPage().getTableWithSummary(text);
    }

    public WebTable getTableWithID(String text) throws SAXException {
        return this.getReceivedPage().getTableWithID(text);
    }

    public Scriptable getScriptableObject() {
        if (this._scriptable == null) {
            this._scriptable = new Scriptable();
        }
        return this._scriptable;
    }

    public static ScriptableDelegate newDelegate(String delegateClassName) {
        if (delegateClassName.equalsIgnoreCase("Option")) {
            return FormControl.newSelectionOption();
        }
        throw new IllegalArgumentException("No such scripting class supported: " + delegateClassName);
    }

    public abstract String toString();

    protected WebResponse(WebClient client, String frameName, URL url) {
        this._client = client;
        this._baseURL = this._pageURL = url;
        this._baseTarget = this._frameName = frameName;
    }

    protected WebResponse(WebClient client, String frameName, URL url, String text) {
        this(client, frameName, url);
        this._responseText = text;
    }

    protected final void defineRawInputStream(InputStream inputStream) throws IOException {
        if (this._inputStream != null || this._responseText != null) {
            throw new IllegalStateException("Must be called before response text is defined.");
        }
        this._inputStream = this.encodedUsingGZIP() ? new GZIPInputStream(inputStream) : inputStream;
    }

    private boolean encodedUsingGZIP() {
        String encoding = this.getHeaderField("Content-Encoding");
        return encoding != null && encoding.indexOf("gzip") >= 0;
    }

    protected void setContentTypeHeader(String value) {
        this._contentHeader = value;
    }

    WebWindow getWindow() {
        return this._window;
    }

    void setWindow(WebWindow window) {
        this._window = window;
    }

    void replaceText(String text, String contentType) {
        if (this._parsingPage) {
            return;
        }
        this._responseText = text;
        this._inputStream = null;
        this._page = null;
        this._contentType = contentType;
    }

    WebRequest[] getFrameRequests() throws SAXException {
        WebFrame[] frames = this.getFrames();
        Vector<WebRequest> requests = new Vector<WebRequest>();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].hasInitialRequest()) {
                requests.addElement(frames[i].getInitialRequest());
            }
            ++i;
        }
        Object[] result = new WebRequest[requests.size()];
        requests.copyInto(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResponseText() throws IOException {
        if (this._responseText != null) {
            throw new IllegalStateException("May only invoke loadResponseText once");
        }
        this._responseText = BLANK_HTML;
        InputStream inputStream = this.getInputStream();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                outputStream.write(buffer, 0, count);
            } while ((count = inputStream.read(buffer, 0, buffer.length)) != -1);
            byte[] bytes = outputStream.toByteArray();
            this.readTags(bytes);
            this._responseText = new String(bytes, this.getCharacterSet());
            this._inputStream = new ByteArrayInputStream(bytes);
            if (HttpUnitOptions.isCheckContentLength() && this.getContentLength() >= 0 && bytes.length != this.getContentLength()) {
                throw new IOException("Truncated message. Expected length: " + this.getContentLength() + ", Actual length: " + bytes.length);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private void readTags(byte[] rawMessage) throws UnsupportedEncodingException, MalformedURLException {
        ByteTagParser parser = new ByteTagParser(rawMessage);
        ByteTag tag = parser.getNextTag();
        while (tag != null) {
            if (tag.getName().equalsIgnoreCase("meta")) {
                this.processMetaTag(tag);
            }
            if (tag.getName().equalsIgnoreCase("base")) {
                this.processBaseTag(tag);
            }
            if (tag.getName().equalsIgnoreCase("frameset")) {
                this._hasSubframes = true;
            }
            if (tag.getName().equalsIgnoreCase("iframe")) {
                this._hasSubframes = true;
            }
            tag = parser.getNextTag();
        }
    }

    private void processBaseTag(ByteTag tag) throws MalformedURLException {
        if (tag.getAttribute("href") != null) {
            this._baseURL = new URL(tag.getAttribute("href"));
        }
        if (tag.getAttribute("target") != null) {
            this._baseTarget = tag.getAttribute("target");
        }
    }

    private void processMetaTag(ByteTag tag) {
        if (this.isHttpEquivMetaTag(tag, "content-type")) {
            this.inferContentType(tag.getAttribute("content"));
        } else if (this.isHttpEquivMetaTag(tag, "refresh")) {
            this.inferRefreshHeader(tag.getAttribute("content"));
        }
    }

    private boolean isHttpEquivMetaTag(ByteTag tag, String headerName) {
        return headerName.equalsIgnoreCase(tag.getAttribute("http_equiv")) || headerName.equalsIgnoreCase(tag.getAttribute("http-equiv"));
    }

    private void inferRefreshHeader(String refreshHeader) {
        String originalHeader = this.getHeaderField("Refresh");
        if (originalHeader == null) {
            this._refreshHeader = refreshHeader;
        }
    }

    private void readRefreshRequest() {
        String refreshHeader;
        if (this._refreshDelay >= 0) {
            return;
        }
        this._refreshDelay = 0;
        String string = refreshHeader = this._refreshHeader != null ? this._refreshHeader : this.getHeaderField("Refresh");
        if (refreshHeader == null) {
            return;
        }
        int splitIndex = refreshHeader.indexOf(59);
        if (splitIndex < 0) {
            splitIndex = 0;
        }
        try {
            this._refreshDelay = Integer.parseInt(refreshHeader.substring(0, splitIndex));
            this._refreshRequest = new GetMethodWebRequest(this._pageURL, this.getRefreshURL(refreshHeader.substring(splitIndex + 1)), this._frameName);
        }
        catch (NumberFormatException e) {
            this._refreshDelay = 0;
            System.out.println("Unable to interpret refresh tag: \"" + refreshHeader + '\"');
        }
    }

    private String getRefreshURL(String text) {
        if (!(text = text.trim()).toUpperCase().startsWith("URL")) {
            return HttpUnitUtils.stripQuotes(text);
        }
        int splitIndex = text.indexOf(61);
        String value = text.substring(splitIndex + 1).trim();
        return HttpUnitUtils.stripQuotes(value);
    }

    private void inferContentType(String contentTypeHeader) {
        String originalHeader = this.getHeaderField("Content-type");
        if (originalHeader == null || originalHeader.indexOf("charset") < 0) {
            this.setContentTypeHeader(contentTypeHeader);
        }
    }

    CookieJar getCookieJar() {
        if (this._cookies == null) {
            this._cookies = new CookieJar(this);
        }
        return this._cookies;
    }

    private void readContentTypeHeader() {
        String contentHeader;
        String string = contentHeader = this._contentHeader != null ? this._contentHeader : this.getHeaderField("Content-type");
        if (contentHeader == null) {
            this._contentType = HttpUnitOptions.getDefaultContentType();
            this.setCharacterSet(HttpUnitOptions.getDefaultCharacterSet());
            this._contentHeader = this._contentType + ";charset=" + this._characterSet;
        } else {
            String[] parts = HttpUnitUtils.parseContentTypeHeader(contentHeader);
            this._contentType = parts[0];
            if (parts[1] != null) {
                this.setCharacterSet(parts[1]);
            }
        }
    }

    private WebFrame[] getFrames() throws SAXException {
        return this.getReceivedPage().getFrames();
    }

    private HTMLPage getReceivedPage() throws SAXException {
        if (this._page == null) {
            try {
                try {
                    this._parsingPage = true;
                    if (!this.isHTML()) {
                        throw new NotHTMLException(this.getContentType());
                    }
                    this._page = new HTMLPage(this, this._frameName, this._baseURL, this._baseTarget, this.getCharacterSet());
                    this._page.parse(this.getText(), this._pageURL);
                    if (this._page == null) {
                        throw new IllegalStateException("replaceText called in the middle of getReceivedPage()");
                    }
                    Object var3_1 = null;
                    this._parsingPage = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this._parsingPage = false;
                throw throwable;
            }
        }
        return this._page;
    }

    static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            int i = 0;
            while (i < DEFAULT_ENCODING_CANDIDATES.length) {
                try {
                    _defaultEncoding = DEFAULT_ENCODING_CANDIDATES[i];
                    "abcd".getBytes(_defaultEncoding);
                    return _defaultEncoding;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ++i;
                }
            }
        }
        _defaultEncoding = System.getProperty("file.encoding");
        return _defaultEncoding;
    }

    private void setCharacterSet(String characterSet) {
        if (characterSet == null) {
            return;
        }
        try {
            "abcd".getBytes(characterSet);
            this._characterSet = characterSet;
        }
        catch (UnsupportedEncodingException e) {
            this._characterSet = WebResponse.getDefaultEncoding();
        }
    }

    boolean hasSubframes() {
        return this._hasSubframes;
    }

    void setCookie(String name, String value) {
        this._client.addCookie(name, value);
    }

    String getCookieHeader() {
        return this._client.getCookieJar().getCookieHeaderField(this.getURL());
    }

    static {
        BLANK_HTML = BLANK_HTML;
        BLANK_RESPONSE = new DefaultWebResponse(BLANK_HTML);
        HTML_CONTENT = HTML_CONTENT;
        UNINITIALIZED_INT = -2;
        DEFAULT_ENCODING_CANDIDATES = new String[]{"iso-8859-1", "us-ascii", "utf-8", "utf8"};
    }

    class ByteTagParser {
        private int _start = 0;
        private int _end = -1;
        private byte[] _buffer;

        ByteTagParser(byte[] buffer) {
            this._buffer = buffer;
        }

        ByteTag getNextTag() throws UnsupportedEncodingException {
            this._start = this._end + 1;
            while (this._start < this._buffer.length && this._buffer[this._start] != 60) {
                ++this._start;
            }
            this._end = this._start + 1;
            while (this._end < this._buffer.length && this._buffer[this._end] != 62) {
                ++this._end;
            }
            if (this._end >= this._buffer.length || this._end < this._start) {
                return null;
            }
            return new ByteTag(this._buffer, this._start + 1, this._end - this._start - 1);
        }
    }

    class ByteTag {
        private String _name = "";
        private Hashtable _attributes;
        private char[] _buffer;
        private int _start;
        private int _end = -1;

        ByteTag(byte[] buffer, int start, int length) throws UnsupportedEncodingException {
            this._buffer = new String(buffer, start, length, WebResponse.getDefaultEncoding()).toCharArray();
            this._name = this.nextToken();
            String attribute = WebResponse.BLANK_HTML;
            String token = this.nextToken();
            while (token.length() != 0) {
                if (token.equals("=") && attribute.length() != 0) {
                    this.getAttributes().put(attribute.toLowerCase(), this.nextToken());
                    attribute = WebResponse.BLANK_HTML;
                } else {
                    if (attribute.length() > 0) {
                        this.getAttributes().put(attribute.toLowerCase(), WebResponse.BLANK_HTML);
                    }
                    attribute = token;
                }
                token = this.nextToken();
            }
        }

        public String getName() {
            return this._name;
        }

        public String getAttribute(String attributeName) {
            return (String)this.getAttributes().get(attributeName);
        }

        public String toString() {
            return "ByteTag[ name=" + this._name + ";attributes = " + this._attributes + ']';
        }

        private Hashtable getAttributes() {
            if (this._attributes == null) {
                this._attributes = new Hashtable();
            }
            return this._attributes;
        }

        private String nextToken() {
            this._start = this._end + 1;
            while (this._start < this._buffer.length && Character.isWhitespace(this._buffer[this._start])) {
                ++this._start;
            }
            if (this._start >= this._buffer.length) {
                return WebResponse.BLANK_HTML;
            }
            if (this._buffer[this._start] == '\"') {
                this._end = this._start + 1;
                while (this._end < this._buffer.length && this._buffer[this._end] != '\"') {
                    ++this._end;
                }
                return new String(this._buffer, this._start + 1, this._end - this._start - 1);
            }
            if (this._buffer[this._start] == '\'') {
                this._end = this._start + 1;
                while (this._end < this._buffer.length && this._buffer[this._end] != '\'') {
                    ++this._end;
                }
                return new String(this._buffer, this._start + 1, this._end - this._start - 1);
            }
            if (this._buffer[this._start] == '=') {
                this._end = this._start;
                return "=";
            }
            this._end = this._start + 1;
            while (this._end < this._buffer.length && this._buffer[this._end] != '=' && !Character.isWhitespace(this._buffer[this._end])) {
                ++this._end;
            }
            return new String(this._buffer, this._start, this._end-- - this._start);
        }
    }

    public class Scriptable
    extends ScriptableDelegate
    implements NamedDelegate {
        public void alert(String message) {
            WebResponse.this._client.postAlert(message);
        }

        public boolean getConfirmationResponse(String message) {
            return WebResponse.this._client.getConfirmationResponse(message);
        }

        public String getUserResponse(String prompt, String defaultResponse) {
            return WebResponse.this._client.getUserResponse(prompt, defaultResponse);
        }

        public ClientProperties getClientProperties() {
            return WebResponse.this._client == null ? ClientProperties.getDefaultProperties() : WebResponse.this._client.getClientProperties();
        }

        public HTMLPage.Scriptable getDocument() {
            try {
                return WebResponse.this.getReceivedPage().getScriptableObject();
            }
            catch (SAXException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Scriptable[] getFrames() throws SAXException {
            String[] names = WebResponse.this.getFrameNames();
            Scriptable[] frames = new Scriptable[names.length];
            int i = 0;
            while (i < frames.length) {
                frames[i] = WebResponse.this.getSubframeContents(names[i]).getScriptableObject();
                ++i;
            }
            return frames;
        }

        public void load() throws SAXException {
            if (WebResponse.this.isHTML()) {
                String[] scripts = WebResponse.this.getReceivedPage().getScripts();
                int i = 0;
                while (i < scripts.length) {
                    this.runScript(scripts[i]);
                    ++i;
                }
                this.doEvent(WebResponse.this.getReceivedPage().getOnLoadEvent());
            }
        }

        public Scriptable open(String urlString, String name, String features, boolean replace) throws IOException, SAXException {
            if (urlString == null || urlString.trim().length() == 0) {
                urlString = "about:";
            }
            GetMethodWebRequest request = new GetMethodWebRequest(this.getURL(), urlString);
            WebWindow[] windows = WebResponse.this._client.getOpenWindows();
            int i = 0;
            while (i < windows.length) {
                WebWindow window = windows[i];
                if (window.getName().equals(name)) {
                    return window.getResponse(request).getScriptableObject();
                }
                ++i;
            }
            return WebResponse.this._client.openInNewWindow(request, name, WebResponse.this).getScriptableObject();
        }

        public void close() {
            if (WebResponse.this.getFrameName().equals("_top")) {
                WebResponse.this._window.close();
            }
        }

        public Object get(String propertyName) {
            if (propertyName.equals("name")) {
                return this.getName();
            }
            if (propertyName.equalsIgnoreCase("top")) {
                return WebResponse.this._window.getFrameContents("_top").getScriptableObject();
            }
            if (propertyName.equalsIgnoreCase("parent")) {
                return WebResponse.this.getFrameName().equals("_top") ? this : WebResponse.this._window.getFrameContents(WebFrame.getParentFrameName(WebResponse.this.getFrameName())).getScriptableObject();
            }
            if (propertyName.equalsIgnoreCase("opener")) {
                return WebResponse.this.getFrameName().equals("_top") ? this.getScriptable(WebResponse.this._window.getOpener()) : null;
            }
            if (propertyName.equalsIgnoreCase("closed")) {
                return WebResponse.this.getFrameName().equals("_top") && WebResponse.this._window.isClosed() ? Boolean.TRUE : Boolean.FALSE;
            }
            try {
                return WebResponse.this.getSubframeContents(propertyName).getScriptableObject();
            }
            catch (NoSuchFrameException e) {
                return super.get(propertyName);
            }
        }

        public String getName() {
            return WebResponse.this.getFrameName().equals("_top") ? WebResponse.this._window.getName() : WebResponse.this.getFrameName();
        }

        private Scriptable getScriptable(WebResponse opener) {
            return opener == null ? null : opener.getScriptableObject();
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equals("name")) {
                if (value == null) {
                    value = WebResponse.BLANK_HTML;
                }
                if (WebResponse.this.getFrameName().equals("_top")) {
                    WebResponse.this._window.setName(value.toString());
                }
            } else {
                super.set(propertyName, value);
            }
        }

        public void setLocation(String relativeURL) throws IOException, SAXException {
            WebResponse.this.getWindow().getResponse(new GetMethodWebRequest(WebResponse.this._pageURL, relativeURL, WebResponse.this._frameName));
        }

        public URL getURL() {
            return WebResponse.this._pageURL;
        }
    }
}

