/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FixedURLWebRequestSource;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebLink
extends FixedURLWebRequestSource {
    public static final HTMLElementPredicate MATCH_URL_STRING = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.contains(((WebLink)htmlElement).getURLString(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_CONTAINED_TEXT = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.contains(((WebLink)htmlElement).asText(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_ID = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.matches(((WebLink)htmlElement).getID(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_NAME = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.matches(((WebLink)htmlElement).getName(), (String)criteria);
        }
    };
    private Scriptable _scriptable;

    public String getURLString() {
        return this.getRelativeURL();
    }

    public String asText() {
        if (this.getNode().getNodeName().equalsIgnoreCase("area")) {
            return this.getAttribute("alt");
        }
        if (!this.getNode().hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this.getNode().getChildNodes()).trim();
    }

    public WebResponse click() throws IOException, SAXException {
        WebResponse response = null;
        String event = this.getAttribute("onclick");
        if (event.length() == 0 || this.getScriptableObject().doEvent(event)) {
            response = this.submitRequest();
        }
        if (response == null) {
            response = this.getBaseResponse().getWindow().getFrameContents(this.getPageFrame());
        }
        return response;
    }

    public void mouseOver() {
        String event = this.getAttribute("onmouseover");
        if (event.length() > 0) {
            this.getScriptableObject().doEvent(event);
        }
    }

    public ScriptableDelegate getScriptableDelegate() {
        return this.getScriptableObject();
    }

    WebLink(WebResponse response, URL baseURL, String parentTarget, Node node) {
        super(response, node, baseURL, NodeUtils.getNodeAttribute(node, "href"), parentTarget);
    }

    Scriptable getScriptableObject() {
        if (this._scriptable == null) {
            this._scriptable = new Scriptable();
            this._scriptable.setScriptEngine(this.getBaseResponse().getScriptableObject().getDocument().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements NamedDelegate {
        public Scriptable() {
            super(WebLink.this);
        }

        public String getName() {
            return WebLink.this.getName();
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("href")) {
                return this.getReference().toExternalForm();
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equals("href")) {
                WebLink.this.setDestination((String)value);
            } else {
                super.set(propertyName, value);
            }
        }

        private URL getReference() {
            try {
                return WebLink.this.getRequest().getURL();
            }
            catch (MalformedURLException e) {
                return WebLink.this.getBaseURL();
            }
        }
    }
}

