/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.IllegalParameterValueException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.SelectionOption;
import com.meterware.httpunit.scripting.SelectionOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SelectionFormControl
extends FormControl {
    private final boolean _multiSelect;
    private final boolean _listBox;
    private Options _selectionOptions;

    SelectionFormControl(WebForm form, Node node) {
        super(form, node);
        if (!node.getNodeName().equalsIgnoreCase("select")) {
            throw new RuntimeException("Not a select element");
        }
        this._multiSelect = NodeUtils.isNodeAttributePresent(node, "multiple");
        this._listBox = this._multiSelect || NodeUtils.isNodeAttributePresent(node, "size");
        this._selectionOptions = new Options(node);
    }

    public String[] getValues() {
        return this._selectionOptions.getSelectedValues();
    }

    public String[] getOptionValues() {
        return this._selectionOptions.getValues();
    }

    public String[] getDisplayedOptions() {
        return this._selectionOptions.getDisplayedText();
    }

    public boolean isMultiValued() {
        return this._multiSelect;
    }

    protected ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    void updateRequiredParameters(Hashtable required) {
        if (this.isReadOnly()) {
            required.put(this.getName(), this.getValues());
        }
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this.isDisabled()) {
            return;
        }
        int i = 0;
        while (i < this.getValues().length) {
            processor.addParameter(this.getName(), this.getValues()[i], characterSet);
            ++i;
        }
    }

    void claimUniqueValue(List values) {
        boolean changed = this._selectionOptions.claimUniqueValues(values);
        if (changed) {
            this.sendOnChangeEvent();
        }
    }

    final void reset() {
        this._selectionOptions.reset();
    }

    class Options
    extends ScriptableDelegate
    implements SelectionOptions {
        private Option[] _options;

        Options(Node selectionNode) {
            NodeList nl = ((Element)selectionNode).getElementsByTagName("option");
            this._options = new Option[nl.getLength()];
            int i = 0;
            while (i < this._options.length) {
                String displayedText = this.getValue(nl.item(i).getFirstChild()).trim();
                this._options[i] = new Option(displayedText, this.getOptionValue(nl.item(i), displayedText), nl.item(i).getAttributes().getNamedItem("selected") != null);
                this._options[i].setIndex(this, i);
                ++i;
            }
        }

        boolean claimUniqueValues(List values) {
            boolean changed = false;
            int numMatches = 0;
            int i = 0;
            while (i < this._options.length) {
                boolean newValue = values.contains(this._options[i].getValue());
                if (newValue != this._options[i].isSelected()) {
                    changed = true;
                }
                this._options[i].setSelected(newValue);
                if (newValue) {
                    values.remove(this._options[i].getValue());
                    ++numMatches;
                    if (!SelectionFormControl.this._multiSelect) {
                        ++i;
                        while (i < this._options.length) {
                            this._options[i].setSelected(false);
                            ++i;
                        }
                    }
                }
                ++i;
            }
            if (!SelectionFormControl.this._listBox && numMatches == 0) {
                throw new IllegalParameterValueException(SelectionFormControl.this.getName(), (String)values.get(0), SelectionFormControl.this.getOptionValues());
            }
            return changed;
        }

        String[] getSelectedValues() {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this._options.length) {
                this._options[i].addValueIfSelected(list);
                ++i;
            }
            if (!SelectionFormControl.this._listBox && list.isEmpty() && this._options.length > 0) {
                list.add(this._options[0].getValue());
            }
            return list.toArray(new String[list.size()]);
        }

        void reset() {
            int i = 0;
            while (i < this._options.length) {
                this._options[i].reset();
                ++i;
            }
        }

        String[] getDisplayedText() {
            String[] displayedText = new String[this._options.length];
            int i = 0;
            while (i < displayedText.length) {
                displayedText[i] = this._options[i].getText();
                ++i;
            }
            return displayedText;
        }

        String[] getValues() {
            String[] values = new String[this._options.length];
            int i = 0;
            while (i < values.length) {
                values[i] = this._options[i].getValue();
                ++i;
            }
            return values;
        }

        void setSelectedIndex(int index) {
            int i = 0;
            while (i < this._options.length) {
                this._options[i]._selected = i == index;
                ++i;
            }
        }

        int getFirstSelectedIndex() {
            int i = 0;
            while (i < this._options.length) {
                if (this._options[i].isSelected()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getLength() {
            return this._options.length;
        }

        public void setLength(int length) {
            if (length < 0 || length >= this._options.length) {
                return;
            }
            Option[] newArray = new Option[length];
            System.arraycopy(this._options, 0, newArray, 0, length);
            this._options = newArray;
        }

        public void put(int i, SelectionOption option) {
            if (i < 0) {
                return;
            }
            if (option == null) {
                if (i >= this._options.length) {
                    return;
                }
                this.deleteOptionsEntry(i);
            } else {
                if (i >= this._options.length) {
                    i = this._options.length;
                    this.expandOptionsArray();
                }
                this._options[i] = (Option)option;
                this._options[i].setIndex(this, i);
                if (option.isSelected()) {
                    this.ensureUniqueOption(i);
                }
            }
        }

        private void ensureUniqueOption(int i) {
            if (SelectionFormControl.this._multiSelect) {
                return;
            }
            int j = 0;
            while (j < this._options.length) {
                this._options[j]._selected = i == j;
                ++j;
            }
        }

        private void deleteOptionsEntry(int i) {
            Option[] newArray = new Option[this._options.length - 1];
            System.arraycopy(this._options, 0, newArray, 0, i);
            System.arraycopy(this._options, i + 1, newArray, i, newArray.length - i);
            this._options = newArray;
        }

        private void expandOptionsArray() {
            Option[] newArray = new Option[this._options.length + 1];
            System.arraycopy(this._options, 0, newArray, 0, this._options.length);
            this._options = newArray;
        }

        public Object get(int index) {
            return this._options[index];
        }

        void optionSet(int i) {
            this.ensureUniqueOption(i);
        }

        private String getOptionValue(Node optionNode, String displayedText) {
            NamedNodeMap nnm = optionNode.getAttributes();
            if (nnm.getNamedItem("value") != null) {
                return this.getValue(nnm.getNamedItem("value"));
            }
            return displayedText;
        }

        private String getValue(Node node) {
            return node == null ? "" : this.emptyIfNull(node.getNodeValue());
        }

        private String emptyIfNull(String value) {
            return value == null ? "" : value;
        }
    }

    static class Option
    extends ScriptableDelegate
    implements SelectionOption {
        private String _text;
        private String _value;
        private boolean _defaultSelected;
        private boolean _selected;
        private int _index;
        private Options _container;

        Option() {
        }

        Option(String text, String value, boolean selected) {
            this._text = text;
            this._value = value;
            this._defaultSelected = this._selected = selected;
        }

        void reset() {
            this._selected = this._defaultSelected;
        }

        void addValueIfSelected(List list) {
            if (this._selected) {
                list.add(this._value);
            }
        }

        void setIndex(Options container, int index) {
            this._container = container;
            this._index = index;
        }

        public void initialize(String text, String value, boolean defaultSelected, boolean selected) {
            this._text = text;
            this._value = value;
            this._defaultSelected = defaultSelected;
            this._selected = selected;
        }

        public int getIndex() {
            return this._index;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String text) {
            this._text = text;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public boolean isDefaultSelected() {
            return this._defaultSelected;
        }

        public void setSelected(boolean selected) {
            this._selected = selected;
            if (selected) {
                this._container.optionSet(this._index);
            }
        }

        public boolean isSelected() {
            return this._selected;
        }
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("options")) {
                return SelectionFormControl.this._selectionOptions;
            }
            if (propertyName.equalsIgnoreCase("length")) {
                return new Integer(SelectionFormControl.this.getOptionValues().length);
            }
            if (propertyName.equalsIgnoreCase("selectedIndex")) {
                return new Integer(SelectionFormControl.this._selectionOptions.getFirstSelectedIndex());
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (!propertyName.equalsIgnoreCase("value")) {
                if (propertyName.equalsIgnoreCase("selectedIndex")) {
                    if (!(value instanceof Number)) {
                        throw new RuntimeException("selectedIndex must be set to an integer");
                    }
                    SelectionFormControl.this._selectionOptions.setSelectedIndex(((Number)value).intValue());
                } else {
                    super.set(propertyName, value);
                }
            }
        }
    }
}

