/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.IllegalParameterValueException;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class RadioGroupFormControl
extends FormControl {
    private List _buttonList = new ArrayList();
    private RadioButtonFormControl[] _buttons;
    private String[] _allowedValues;

    public RadioGroupFormControl(WebForm form) {
        super(form);
    }

    void addRadioButton(RadioButtonFormControl control) {
        this._buttonList.add(control);
        this._buttons = null;
        this._allowedValues = null;
    }

    public String[] getValues() {
        int i = 0;
        while (i < this.getButtons().length) {
            if (this.getButtons()[i].isChecked()) {
                return this.getButtons()[i].getValues();
            }
            ++i;
        }
        return FormControl.NO_VALUE;
    }

    public String[] getOptionValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        RadioButtonFormControl[] buttons = this.getButtons();
        int i = 0;
        while (i < buttons.length) {
            valueList.addAll(Arrays.asList(((FormControl)buttons[i]).getOptionValues()));
            ++i;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    Object getDelegate() {
        ScriptableDelegate[] delegates = new ScriptableDelegate[this.getButtons().length];
        int i = 0;
        while (i < delegates.length) {
            delegates[i] = this.getButtons()[i].getScriptableDelegate();
            ++i;
        }
        return delegates;
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        int i = 0;
        while (i < this.getButtons().length) {
            this.getButtons()[i].addValues(processor, characterSet);
            ++i;
        }
    }

    void claimRequiredValues(List values) {
        int i = 0;
        while (i < this.getButtons().length) {
            this.getButtons()[i].claimRequiredValues(values);
            ++i;
        }
    }

    void claimUniqueValue(List values) {
        int matchingButtonIndex = -1;
        int i = 0;
        while (i < this.getButtons().length && matchingButtonIndex < 0) {
            if (!this.getButtons()[i].isReadOnly() && values.contains(this.getButtons()[i].getQueryValue())) {
                matchingButtonIndex = i;
            }
            ++i;
        }
        if (matchingButtonIndex < 0) {
            throw new IllegalParameterValueException(this.getButtons()[0].getName(), (String)values.get(0), this.getAllowedValues());
        }
        boolean wasChecked = this.getButtons()[matchingButtonIndex].isChecked();
        int i2 = 0;
        while (i2 < this.getButtons().length) {
            if (!this.getButtons()[i2].isReadOnly()) {
                this.getButtons()[i2].setChecked(i2 == matchingButtonIndex);
            }
            ++i2;
        }
        values.remove(this.getButtons()[matchingButtonIndex].getQueryValue());
        if (!wasChecked) {
            this.getButtons()[matchingButtonIndex].sendOnClickEvent();
        }
    }

    void reset() {
        int i = 0;
        while (i < this.getButtons().length) {
            this.getButtons()[i].reset();
            ++i;
        }
    }

    private String[] getAllowedValues() {
        if (this._allowedValues == null) {
            this._allowedValues = new String[this.getButtons().length];
            int i = 0;
            while (i < this._allowedValues.length) {
                this._allowedValues[i] = this.getButtons()[i].getQueryValue();
                ++i;
            }
        }
        return this._allowedValues;
    }

    private RadioButtonFormControl[] getButtons() {
        if (this._buttons == null) {
            this._buttons = this._buttonList.toArray(new RadioButtonFormControl[this._buttonList.size()]);
        }
        return this._buttons;
    }
}

