/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HttpUnitUtils {
    public static final int DEFAULT_TEXT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_BUFFER_SIZE = 128;
    static final String DEFAULT_CHARACTER_SET = "iso-8859-1";

    public static String[] parseContentTypeHeader(String header) {
        String[] result = new String[]{"text/plain", null};
        StringTokenizer st = new StringTokenizer(header, ";=");
        result[0] = st.nextToken();
        while (st.hasMoreTokens()) {
            String parameter = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String value = HttpUnitUtils.stripQuotes(st.nextToken());
            if (!parameter.trim().equalsIgnoreCase("charset")) continue;
            result[1] = value;
        }
        return result;
    }

    public static String stripQuotes(String value) {
        if (value.startsWith("'") || value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("'") || value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String decode(String byteString) {
        char[] chars = byteString.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length);
        char[] hexNum = new char[]{'0', '0', '0'};
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '+') {
                ++i;
                sb.append(' ');
                continue;
            }
            if (chars[i] == '%') {
                int n = ++i;
                hexNum[1] = chars[n];
                int n2 = ++i;
                ++i;
                hexNum[2] = chars[n2];
                sb.append((char)Integer.parseInt(new String(hexNum), 16));
                continue;
            }
            sb.append(chars[i++]);
        }
        return sb.toString();
    }

    public static DocumentBuilder newParser() throws SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
    }

    static String[] withNewValue(String[] oldValue, String newValue) {
        String[] result;
        if (oldValue == null) {
            result = new String[]{newValue};
        } else {
            result = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, result, 0, oldValue.length);
            result[oldValue.length] = newValue;
        }
        return result;
    }

    static Object[] withNewValue(Object[] oldValue, Object newValue) {
        Object[] result;
        if (oldValue == null) {
            result = new Object[]{newValue};
        } else {
            result = new Object[oldValue.length + 1];
            System.arraycopy(oldValue, 0, result, 0, oldValue.length);
            result[oldValue.length] = newValue;
        }
        return result;
    }

    static boolean contains(String string, String substring) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().indexOf(substring.toUpperCase()) >= 0;
        }
        return string.indexOf(substring) >= 0;
    }

    static boolean hasPrefix(String string, String prefix) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().startsWith(prefix.toUpperCase());
        }
        return string.startsWith(prefix);
    }

    static boolean matches(String string1, String string2) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string1.equalsIgnoreCase(string2);
        }
        return string1.equals(string2);
    }

    static {
        DEFAULT_TEXT_BUFFER_SIZE = 2048;
        DEFAULT_BUFFER_SIZE = 128;
        DEFAULT_CHARACTER_SET = DEFAULT_CHARACTER_SET;
    }
}

