/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HTMLPage
extends ParsedHTML {
    private Scriptable _scriptable;

    HTMLPage(WebResponse response, String frameName, URL baseURL, String baseTarget, String characterSet) throws IOException, SAXException {
        super(response, frameName, baseURL, baseTarget, null, characterSet);
    }

    public String getTitle() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("title");
        if (nl.getLength() == 0) {
            return "";
        }
        if (!nl.item(0).hasChildNodes()) {
            return "";
        }
        return nl.item(0).getFirstChild().getNodeValue();
    }

    public String getOnLoadEvent() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("body");
        if (nl.getLength() == 0) {
            return "";
        }
        return ((Element)nl.item(0)).getAttribute("onload");
    }

    public String[] getScripts() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("script");
        ArrayList<String> scripts = new ArrayList<String>();
        int i = 0;
        while (i < nl.getLength()) {
            Node scriptNode = nl.item(i);
            String language = NodeUtils.getNodeAttribute(scriptNode, "language", null);
            if (language == null || language.startsWith("JavaScript")) {
                String scriptLocation = NodeUtils.getNodeAttribute(scriptNode, "src", null);
                if (scriptLocation == null) {
                    scripts.add(NodeUtils.asText(scriptNode.getChildNodes()));
                } else {
                    try {
                        scripts.add(this.getIncludedScript(scriptLocation));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading included script: " + e);
                    }
                }
            }
            ++i;
        }
        return scripts.toArray(new String[scripts.size()]);
    }

    String getIncludedScript(String srcAttribute) throws IOException {
        GetMethodWebRequest req = new GetMethodWebRequest(this.getBaseURL(), srcAttribute);
        return this.getResponse().getWindow().getResource(req).getText();
    }

    public String getExternalStyleSheet() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("link");
        int length = nl.getLength();
        if (length == 0) {
            return "";
        }
        int i = 0;
        while (i < length) {
            if ("stylesheet".equalsIgnoreCase(NodeUtils.getNodeAttribute(nl.item(i), "rel"))) {
                return NodeUtils.getNodeAttribute(nl.item(i), "href");
            }
            ++i;
        }
        return "";
    }

    public String[] getMetaTagContent(String attribute, String attributeValue) {
        Vector<String> matches = new Vector<String>();
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("meta");
        int length = nl.getLength();
        int i = 0;
        while (i < length) {
            if (attributeValue.equalsIgnoreCase(NodeUtils.getNodeAttribute(nl.item(i), attribute))) {
                matches.addElement(NodeUtils.getNodeAttribute(nl.item(i), "content"));
            }
            ++i;
        }
        Object[] result = new String[matches.size()];
        matches.copyInto(result);
        return result;
    }

    Scriptable getScriptableObject() {
        if (this._scriptable == null) {
            this._scriptable = new Scriptable();
            this._scriptable.setScriptEngine(this.getResponse().getScriptableObject().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    public void parse(String text, URL pageURL) throws SAXException, IOException {
        HTMLParserFactory.getHTMLParser().parse(pageURL, text, new DocumentAdapter(){

            public void setRootNode(Node rootNode) {
                HTMLPage.this.setRootNode(rootNode);
            }

            public String getIncludedScript(String srcAttribute) throws IOException {
                return HTMLPage.this.getIncludedScript(srcAttribute);
            }

            public ScriptableDelegate getScriptableObject() {
                return HTMLPage.this.getScriptableObject().getParent();
            }
        });
    }

    public class Scriptable
    extends ScriptableDelegate {
        public Object get(String propertyName) {
            NamedDelegate delegate = this.getNamedItem(this.getForms(), propertyName);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.getNamedItem(this.getLinks(), propertyName);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.getNamedItem(this.getImages(), propertyName);
            if (delegate != null) {
                return delegate;
            }
            return super.get(propertyName);
        }

        private NamedDelegate getNamedItem(NamedDelegate[] items, String name) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getName().equals(name)) {
                    return items[i];
                }
                ++i;
            }
            return null;
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("location")) {
                HTMLPage.this.getResponse().getScriptableObject().set("location", value);
            } else {
                super.set(propertyName, value);
            }
        }

        public WebResponse.Scriptable getParent() {
            return HTMLPage.this.getResponse().getScriptableObject();
        }

        public String getTitle() throws SAXException {
            return HTMLPage.this.getTitle();
        }

        public WebLink.Scriptable[] getLinks() {
            WebLink[] links = HTMLPage.this.getLinks();
            WebLink.Scriptable[] result = new WebLink.Scriptable[links.length];
            int i = 0;
            while (i < links.length) {
                result[i] = links[i].getScriptableObject();
                ++i;
            }
            return result;
        }

        public WebForm.Scriptable[] getForms() {
            WebForm[] forms = HTMLPage.this.getForms();
            WebForm.Scriptable[] result = new WebForm.Scriptable[forms.length];
            int i = 0;
            while (i < forms.length) {
                result[i] = forms[i].getScriptableObject();
                ++i;
            }
            return result;
        }

        public WebImage.Scriptable[] getImages() {
            WebImage[] images = HTMLPage.this.getImages();
            WebImage.Scriptable[] result = new WebImage.Scriptable[images.length];
            int i = 0;
            while (i < images.length) {
                result[i] = images[i].getScriptableObject();
                ++i;
            }
            return result;
        }

        Scriptable() {
        }

        public void replaceText(String text, String contentType) {
            HTMLPage.this.getResponse().replaceText(text, contentType);
        }

        public void setCookie(String name, String value) {
            HTMLPage.this.getResponse().setCookie(name, value);
        }

        public String getCookie() {
            return HTMLPage.this.getResponse().getCookieHeader();
        }

        public ScriptableDelegate getElementWithID(String id) {
            HTMLElement elementWithID = HTMLPage.this.getElementWithID(id);
            return elementWithID == null ? null : elementWithID.getScriptableDelegate();
        }
    }
}

