/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.exports;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import jdk.nashorn.api.scripting.AbstractJSObject;
import me.lucko.scriptcontroller.exports.Export;

final class ExportImpl<T>
implements Export<T> {
    private final String name;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private T value = null;
    private Export.Pointer<T> pointer = null;

    ExportImpl(String name) {
        this.name = name;
    }

    private Lock readLock() {
        return this.lock.readLock();
    }

    private Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public synchronized Export.Pointer<T> pointer() {
        if (this.pointer == null) {
            this.pointer = new PointerImpl(this);
        }
        return this.pointer;
    }

    @Override
    public T get() {
        this.readLock().lock();
        try {
            T t = this.value;
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public T get(T other) {
        T value = this.get();
        return value != null ? value : other;
    }

    @Override
    public Export<T> put(T value) {
        this.writeLock().lock();
        try {
            this.value = value;
        }
        finally {
            this.writeLock().unlock();
        }
        return this;
    }

    @Override
    public Export<T> putIfAbsent(T value) {
        this.writeLock().lock();
        try {
            if (this.value == null) {
                this.value = value;
            }
        }
        finally {
            this.writeLock().unlock();
        }
        return this;
    }

    @Override
    public Export<T> computeIfAbsent(Supplier<? extends T> other) {
        this.writeLock().lock();
        try {
            if (this.value == null) {
                this.value = other.get();
            }
        }
        finally {
            this.writeLock().unlock();
        }
        return this;
    }

    @Override
    public boolean containsValue() {
        this.readLock().lock();
        try {
            boolean bl = this.value != null;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock().lock();
        try {
            this.value = null;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private static final class PointerImpl<T>
    extends AbstractJSObject
    implements Export.Pointer<T> {
        private final Export<T> export;

        private PointerImpl(Export<T> export) {
            this.export = export;
        }

        public boolean isFunction() {
            return true;
        }

        public Object call(Object thiz, Object ... args) {
            return this.get();
        }

        @Override
        public T get() {
            return this.export.get();
        }
    }
}

