/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.closable;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import me.lucko.scriptcontroller.closable.CompositeAutoClosable;
import me.lucko.scriptcontroller.closable.CompositeClosingException;

class CompositeAutoClosableImpl
implements CompositeAutoClosable {
    private final Deque<AutoCloseable> closeables = new ConcurrentLinkedDeque<AutoCloseable>();

    CompositeAutoClosableImpl() {
    }

    @Override
    public CompositeAutoClosable bind(AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable");
        this.closeables.push(autoCloseable);
        return this;
    }

    @Override
    public void close() throws CompositeClosingException {
        AutoCloseable ac;
        ArrayList<Exception> caught = new ArrayList<Exception>();
        while ((ac = this.closeables.poll()) != null) {
            try {
                ac.close();
            }
            catch (Exception e) {
                caught.add(e);
            }
        }
        if (!caught.isEmpty()) {
            throw new CompositeClosingException(caught);
        }
    }
}

