/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.closable;

import me.lucko.scriptcontroller.closable.CompositeAutoClosableImpl;
import me.lucko.scriptcontroller.closable.CompositeClosingException;

public interface CompositeAutoClosable
extends AutoCloseable {
    public static CompositeAutoClosable create() {
        return new CompositeAutoClosableImpl();
    }

    public CompositeAutoClosable bind(AutoCloseable var1);

    default public CompositeAutoClosable bindAll(AutoCloseable ... autoCloseables) {
        for (AutoCloseable autoCloseable : autoCloseables) {
            if (autoCloseable == null) continue;
            this.bind(autoCloseable);
        }
        return this;
    }

    default public CompositeAutoClosable bindAll(Iterable<? extends AutoCloseable> autoCloseables) {
        for (AutoCloseable autoCloseable : autoCloseables) {
            if (autoCloseable == null) continue;
            this.bind(autoCloseable);
        }
        return this;
    }

    @Override
    public void close() throws CompositeClosingException;

    default public void closeSilently() {
        try {
            this.close();
        }
        catch (CompositeClosingException compositeClosingException) {
            // empty catch block
        }
    }

    default public void closeAndReportExceptions() {
        try {
            this.close();
        }
        catch (CompositeClosingException e) {
            e.printAllStackTraces();
        }
    }
}

