/*
 * Decompiled with CFR 0.152.
 */
package me.andrz.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.util.List;
import me.andrz.jackson.JsonReferenceException;
import me.andrz.jackson.JsonReferenceProcessor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JsonReferenceCli {
    public static void main(String[] args) throws ParseException, JsonReferenceException, IOException {
        Options options = new Options();
        Option helpOption = new Option("help", null);
        options.addOption(helpOption);
        DefaultParser commandLineParser = new DefaultParser();
        CommandLine commandLine = commandLineParser.parse(options, args);
        Boolean help = commandLine.hasOption("help");
        if (help.booleanValue()) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("json-reference", options);
            return;
        }
        List<String> argsList = commandLine.getArgList();
        File file = new File(argsList.get(0));
        JsonReferenceProcessor processor = new JsonReferenceProcessor();
        JsonNode jsonNode = processor.process(file);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.writeValue(System.out, (Object)jsonNode);
        System.out.println();
    }
}

