/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.message;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.alidg.errors.Argument;
import me.alidg.errors.message.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class TemplateAwareMessageSource {
    private static final Logger logger = LoggerFactory.getLogger(TemplateAwareMessageSource.class);
    private final MessageSource messageSource;
    private final TemplateParser templateParser = new TemplateParser();

    public TemplateAwareMessageSource(@NonNull MessageSource messageSource) {
        this.messageSource = Objects.requireNonNull(messageSource, "The message source is required");
    }

    @Nullable
    public String interpolate(@NonNull String code, @NonNull List<Argument> arguments, @NonNull Locale locale) {
        try {
            String template = this.messageSource.getMessage(code, null, locale);
            return this.templateParser.parse(template, arguments);
        }
        catch (NoSuchMessageException e) {
            return null;
        }
        catch (Exception e) {
            logger.warn("Failed to interpolate a message", (Throwable)e);
            return null;
        }
    }
}

