/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public class TypeMismatchWebErrorHandler
implements WebErrorHandler {
    public static final String TYPE_MISMATCH = "binding.type_mismatch";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof TypeMismatchException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        TypeMismatchException mismatchException = (TypeMismatchException)exception;
        String errorCode = TypeMismatchWebErrorHandler.getErrorCode(mismatchException);
        List<Argument> arguments = TypeMismatchWebErrorHandler.getArguments(mismatchException);
        return new HandledException(errorCode, HttpStatus.BAD_REQUEST, Collections.singletonMap(errorCode, arguments));
    }

    static List<Argument> getArguments(TypeMismatchException mismatchException) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add(Argument.arg("property", TypeMismatchWebErrorHandler.getPropertyName(mismatchException)));
        arguments.add(Argument.arg("invalid", mismatchException.getValue()));
        if (mismatchException.getRequiredType() != null) {
            arguments.add(Argument.arg("expected", mismatchException.getRequiredType().getSimpleName()));
        }
        return arguments;
    }

    static String getErrorCode(TypeMismatchException mismatchException) {
        return "binding.type_mismatch." + TypeMismatchWebErrorHandler.getPropertyName(mismatchException);
    }

    private static String getPropertyName(TypeMismatchException mismatchException) {
        if (mismatchException instanceof MethodArgumentTypeMismatchException) {
            return ((MethodArgumentTypeMismatchException)mismatchException).getName();
        }
        return mismatchException.getPropertyName();
    }
}

