/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.handlers.ConstraintViolationArgumentsExtractor;
import me.alidg.errors.handlers.TypeMismatchWebErrorHandler;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class SpringValidationWebErrorHandler
implements WebErrorHandler {
    public static final String BINDING_FAILURE = "binding.failure";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof MethodArgumentNotValidException || exception instanceof BindException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        BindingResult bindingResult = this.getBindingResult(exception);
        return bindingResult.getAllErrors().stream().collect(Collectors.collectingAndThen(Collectors.toMap(this::errorCode, this::arguments, (value1, value2) -> value1), m -> new HandledException(m.keySet(), HttpStatus.BAD_REQUEST, this.dropEmptyValues((Map<String, List<Argument>>)m))));
    }

    private BindingResult getBindingResult(Throwable exception) {
        return exception instanceof BindingResult ? (BindingResult)exception : ((MethodArgumentNotValidException)exception).getBindingResult();
    }

    private String errorCode(ObjectError error) {
        String code = null;
        try {
            code = ((ConstraintViolation)error.unwrap(ConstraintViolation.class)).getMessageTemplate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (code == null) {
            try {
                code = TypeMismatchWebErrorHandler.getErrorCode((TypeMismatchException)error.unwrap(TypeMismatchException.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (code == null) {
            code = BINDING_FAILURE;
        }
        return code.replace("{", "").replace("}", "");
    }

    private List<Argument> arguments(ObjectError error) {
        try {
            ConstraintViolation violation = (ConstraintViolation)error.unwrap(ConstraintViolation.class);
            return ConstraintViolationArgumentsExtractor.extract(violation);
        }
        catch (Exception exception) {
            try {
                return TypeMismatchWebErrorHandler.getArguments((TypeMismatchException)error.unwrap(TypeMismatchException.class));
            }
            catch (Exception exception2) {
                return Collections.emptyList();
            }
        }
    }

    private Map<String, List<Argument>> dropEmptyValues(Map<String, List<Argument>> input) {
        return input.entrySet().stream().filter(e -> e.getValue() != null && !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
    }
}

