/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.util.MimeType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

public class ServletWebErrorHandler
implements WebErrorHandler {
    public static final String INVALID_OR_MISSING_BODY = "web.invalid_or_missing_body";
    public static final String NOT_ACCEPTABLE = "web.not_acceptable";
    public static final String NOT_SUPPORTED = "web.unsupported_media_type";
    public static final String METHOD_NOT_ALLOWED = "web.method_not_allowed";
    public static final String MISSING_PARAMETER = "web.missing_parameter";
    public static final String MISSING_PART = "web.missing_part";
    public static final String NO_HANDLER = "web.no_handler";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof HttpMediaTypeNotAcceptableException || exception instanceof HttpMediaTypeNotSupportedException || exception instanceof HttpRequestMethodNotSupportedException || exception instanceof MissingServletRequestParameterException || exception instanceof MissingServletRequestPartException || exception instanceof NoHandlerFoundException || exception instanceof HttpMessageNotReadableException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        if (exception instanceof HttpMessageNotReadableException) {
            return new HandledException(INVALID_OR_MISSING_BODY, HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof HttpMediaTypeNotAcceptableException) {
            Set<String> types = this.getMediaTypes(((HttpMediaTypeNotAcceptableException)exception).getSupportedMediaTypes());
            Map<String, List<Argument>> args = types.isEmpty() ? Collections.emptyMap() : Collections.singletonMap(NOT_ACCEPTABLE, Collections.singletonList(Argument.arg("types", types)));
            return new HandledException(NOT_ACCEPTABLE, HttpStatus.NOT_ACCEPTABLE, args);
        }
        if (exception instanceof HttpMediaTypeNotSupportedException) {
            MediaType contentType = ((HttpMediaTypeNotSupportedException)exception).getContentType();
            List<Argument> arguments = null;
            if (contentType != null) {
                arguments = Collections.singletonList(Argument.arg("type", contentType.toString()));
            }
            return new HandledException(NOT_SUPPORTED, HttpStatus.UNSUPPORTED_MEDIA_TYPE, arguments == null ? Collections.emptyMap() : Collections.singletonMap(NOT_SUPPORTED, arguments));
        }
        if (exception instanceof HttpRequestMethodNotSupportedException) {
            String method = ((HttpRequestMethodNotSupportedException)exception).getMethod();
            return new HandledException(METHOD_NOT_ALLOWED, HttpStatus.METHOD_NOT_ALLOWED, Collections.singletonMap(METHOD_NOT_ALLOWED, Collections.singletonList(Argument.arg("method", method))));
        }
        if (exception instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException actualException = (MissingServletRequestParameterException)exception;
            String name = actualException.getParameterName();
            String type = actualException.getParameterType();
            return new HandledException(MISSING_PARAMETER, HttpStatus.BAD_REQUEST, Collections.singletonMap(MISSING_PARAMETER, Arrays.asList(Argument.arg("name", name), Argument.arg("expected", type))));
        }
        if (exception instanceof MissingServletRequestPartException) {
            String name = ((MissingServletRequestPartException)exception).getRequestPartName();
            return new HandledException(MISSING_PART, HttpStatus.BAD_REQUEST, Collections.singletonMap(MISSING_PART, Collections.singletonList(Argument.arg("name", name))));
        }
        if (exception instanceof NoHandlerFoundException) {
            String url = ((NoHandlerFoundException)exception).getRequestURL();
            return new HandledException(NO_HANDLER, HttpStatus.NOT_FOUND, Collections.singletonMap(NO_HANDLER, Collections.singletonList(Argument.arg("path", url))));
        }
        return new HandledException("unknown_error", HttpStatus.INTERNAL_SERVER_ERROR, null);
    }

    private Set<String> getMediaTypes(List<MediaType> mediaTypes) {
        if (mediaTypes == null) {
            return Collections.emptySet();
        }
        return mediaTypes.stream().map(MimeType::toString).collect(Collectors.toSet());
    }
}

