/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.handlers.SpringValidationWebErrorHandler;
import me.alidg.errors.handlers.TypeMismatchWebErrorHandler;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.MediaTypeNotSupportedStatusException;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

public class ResponseStatusWebErrorHandler
implements WebErrorHandler {
    private final SpringValidationWebErrorHandler validationWebErrorHandler = new SpringValidationWebErrorHandler();
    private final TypeMismatchWebErrorHandler typeMismatchWebErrorHandler = new TypeMismatchWebErrorHandler();

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof ResponseStatusException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        if (exception instanceof MediaTypeNotSupportedStatusException) {
            Set<String> types = this.getMediaTypes(((MediaTypeNotSupportedStatusException)exception).getSupportedMediaTypes());
            Map<String, List<Argument>> args = types.isEmpty() ? Collections.emptyMap() : ResponseStatusWebErrorHandler.argMap("web.unsupported_media_type", Argument.arg("types", types));
            return new HandledException("web.unsupported_media_type", HttpStatus.UNSUPPORTED_MEDIA_TYPE, args);
        }
        if (exception instanceof UnsupportedMediaTypeStatusException) {
            Set<String> types = this.getMediaTypes(((UnsupportedMediaTypeStatusException)exception).getSupportedMediaTypes());
            Map<String, List<Argument>> args = types.isEmpty() ? Collections.emptyMap() : ResponseStatusWebErrorHandler.argMap("web.unsupported_media_type", Argument.arg("types", types));
            return new HandledException("web.unsupported_media_type", HttpStatus.UNSUPPORTED_MEDIA_TYPE, args);
        }
        if (exception instanceof NotAcceptableStatusException) {
            Set<String> types = this.getMediaTypes(((NotAcceptableStatusException)exception).getSupportedMediaTypes());
            Map<String, List<Argument>> args = types.isEmpty() ? Collections.emptyMap() : ResponseStatusWebErrorHandler.argMap("web.not_acceptable", Argument.arg("types", types));
            return new HandledException("web.not_acceptable", HttpStatus.NOT_ACCEPTABLE, args);
        }
        if (exception instanceof MethodNotAllowedException) {
            String httpMethod = ((MethodNotAllowedException)exception).getHttpMethod();
            return new HandledException("web.method_not_allowed", HttpStatus.METHOD_NOT_ALLOWED, ResponseStatusWebErrorHandler.argMap("web.method_not_allowed", Argument.arg("method", httpMethod)));
        }
        if (exception instanceof WebExchangeBindException) {
            return this.validationWebErrorHandler.handle(exception);
        }
        if (exception instanceof ServerWebInputException) {
            MethodParameter parameter = ((ServerWebInputException)exception).getMethodParameter();
            if (exception.getCause() instanceof TypeMismatchException) {
                TypeMismatchException cause = (TypeMismatchException)exception.getCause();
                if (cause.getPropertyName() == null) {
                    cause.initPropertyName(parameter.getParameterName());
                }
                return this.typeMismatchWebErrorHandler.handle((Throwable)cause);
            }
            HandledException handledException = this.handleMissingParameters(parameter);
            if (handledException != null) {
                return handledException;
            }
            return new HandledException("web.invalid_or_missing_body", HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof ResponseStatusException) {
            HttpStatus status = ((ResponseStatusException)exception).getStatus();
            if (status == HttpStatus.NOT_FOUND) {
                return new HandledException("web.no_handler", status, null);
            }
            return new HandledException("unknown_error", status, null);
        }
        return new HandledException("unknown_error", HttpStatus.INTERNAL_SERVER_ERROR, null);
    }

    private HandledException handleMissingParameters(MethodParameter parameter) {
        MatrixVariable matrixVariable;
        CookieValue cookieValue;
        RequestPart requestPart;
        RequestParam requestParam;
        if (parameter == null) {
            return null;
        }
        String code = null;
        String parameterName = null;
        RequestHeader requestHeader = (RequestHeader)parameter.getParameterAnnotation(RequestHeader.class);
        if (requestHeader != null) {
            code = "web.missing_header";
            parameterName = this.extractParameterName((Annotation)requestHeader, parameter);
        }
        if ((requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class)) != null) {
            code = "web.missing_parameter";
            parameterName = this.extractParameterName((Annotation)requestParam, parameter);
        }
        if ((requestPart = (RequestPart)parameter.getParameterAnnotation(RequestPart.class)) != null) {
            code = "web.missing_part";
            parameterName = this.extractParameterName((Annotation)requestPart, parameter);
        }
        if ((cookieValue = (CookieValue)parameter.getParameterAnnotation(CookieValue.class)) != null) {
            code = "web.missing_cookie";
            parameterName = this.extractParameterName((Annotation)cookieValue, parameter);
        }
        if ((matrixVariable = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class)) != null) {
            code = "web.missing_matrix_variable";
            parameterName = this.extractParameterName((Annotation)matrixVariable, parameter);
        }
        if (code != null) {
            return new HandledException(code, HttpStatus.BAD_REQUEST, ResponseStatusWebErrorHandler.argMap(code, Argument.arg("name", parameterName), Argument.arg("expected", parameter.getParameterType().getSimpleName())));
        }
        return null;
    }

    private static Map<String, List<Argument>> argMap(String code, Argument ... arguments) {
        return Collections.singletonMap(code, Arrays.asList(arguments));
    }

    private String extractParameterName(Annotation annotation, MethodParameter parameter) {
        String name = this.getNameAttribute(annotation);
        return name.isEmpty() ? parameter.getParameterName() : name;
    }

    private Set<String> getMediaTypes(List<MediaType> mediaTypes) {
        if (mediaTypes == null) {
            return Collections.emptySet();
        }
        return mediaTypes.stream().map(MimeType::toString).collect(Collectors.toSet());
    }

    private String getNameAttribute(Annotation annotation) {
        try {
            Method method = annotation.getClass().getMethod("name", new Class[0]);
            return (String)method.invoke((Object)method, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }
}

