/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.conf;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alidg.errors.Argument;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.NonNull;

@ConfigurationProperties(value="errors")
public class ErrorsProperties {
    @NonNull
    private ArgumentExposure exposeArguments = ArgumentExposure.NEVER;
    private boolean addFingerprint = false;

    public ArgumentExposure getExposeArguments() {
        return this.exposeArguments;
    }

    public void setExposeArguments(ArgumentExposure exposeArguments) {
        this.exposeArguments = exposeArguments;
    }

    public boolean isAddFingerprint() {
        return this.addFingerprint;
    }

    public void setAddFingerprint(boolean addFingerprint) {
        this.addFingerprint = addFingerprint;
    }

    public static enum ArgumentExposure {
        NEVER,
        NON_EMPTY{

            @Override
            public void expose(Map<String, Object> error, List<Argument> arguments) {
                if (!arguments.isEmpty()) {
                    error.put("arguments", ArgumentExposure.argumentsMap(arguments));
                }
            }
        }
        ,
        ALWAYS{

            @Override
            public void expose(Map<String, Object> error, List<Argument> arguments) {
                error.put("arguments", ArgumentExposure.argumentsMap(arguments));
            }
        };


        private static Map<String, Object> argumentsMap(List<Argument> arguments) {
            if (arguments == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> argumentMap = new HashMap<String, Object>();
            for (Argument argument : arguments) {
                argumentMap.put(argument.getName(), argument.getValue());
            }
            return argumentMap;
        }

        public void expose(Map<String, Object> error, List<Argument> arguments) {
        }
    }
}

