/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.adapter.attributes;

import java.util.Map;
import java.util.Objects;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import me.alidg.errors.adapter.attributes.Exceptions;
import org.springframework.boot.web.reactive.error.DefaultErrorAttributes;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.reactive.function.server.ServerRequest;

public class ReactiveErrorAttributes
extends DefaultErrorAttributes {
    private final WebErrorHandlers webErrorHandlers;
    private final HttpErrorAttributesAdapter httpErrorAttributesAdapter;

    public ReactiveErrorAttributes(WebErrorHandlers webErrorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        super(true);
        this.webErrorHandlers = Objects.requireNonNull(webErrorHandlers, "Web error handlers is required");
        this.httpErrorAttributesAdapter = Objects.requireNonNull(httpErrorAttributesAdapter, "Adapter is required");
    }

    public Map<String, Object> getErrorAttributes(ServerRequest request, boolean includeStackTrace) {
        Map attributes = super.getErrorAttributes(request, includeStackTrace);
        Throwable exception = this.getError(request);
        if (exception == null) {
            exception = Exceptions.refineUnknownException(attributes);
        }
        HttpError httpError = this.webErrorHandlers.handle(exception, request, LocaleContextHolder.getLocale());
        Map<String, Object> adapted = this.httpErrorAttributesAdapter.adapt(httpError);
        adapted.put("status", httpError.getHttpStatus().value());
        return adapted;
    }
}

