/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import me.alidg.errors.Argument;
import me.alidg.errors.ExceptionLogger;
import me.alidg.errors.ExceptionRefiner;
import me.alidg.errors.FingerprintProvider;
import me.alidg.errors.HandledException;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.WebErrorHandlerPostProcessor;
import me.alidg.errors.WebErrorHandlersBuilder;
import me.alidg.errors.conf.ErrorsProperties;
import me.alidg.errors.fingerprint.UuidFingerprintProvider;
import me.alidg.errors.handlers.LastResortWebErrorHandler;
import me.alidg.errors.message.TemplateAwareMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class WebErrorHandlers {
    private static final Logger log = LoggerFactory.getLogger(WebErrorHandlers.class);
    @NonNull
    private final List<WebErrorHandler> webErrorHandlers;
    @NonNull
    private final ExceptionRefiner exceptionRefiner;
    @NonNull
    private final ExceptionLogger exceptionLogger;
    @NonNull
    private final List<WebErrorHandlerPostProcessor> webErrorHandlerPostProcessors;
    @NonNull
    private final FingerprintProvider fingerprintProvider;
    @NonNull
    private final ErrorsProperties errorsProperties;
    @NonNull
    private final TemplateAwareMessageSource messageSource;
    @NonNull
    private WebErrorHandler defaultWebErrorHandler = LastResortWebErrorHandler.INSTANCE;

    @Deprecated
    public WebErrorHandlers(@NonNull MessageSource messageSource, @NonNull List<WebErrorHandler> webErrorHandlers, @Nullable WebErrorHandler defaultWebErrorHandler, @Nullable ExceptionRefiner exceptionRefiner, @Nullable ExceptionLogger exceptionLogger) {
        this(messageSource, webErrorHandlers, defaultWebErrorHandler, exceptionRefiner != null ? exceptionRefiner : ExceptionRefiner.NoOp.INSTANCE, exceptionLogger != null ? exceptionLogger : ExceptionLogger.NoOp.INSTANCE, Collections.emptyList(), new UuidFingerprintProvider(), new ErrorsProperties());
    }

    WebErrorHandlers(@NonNull MessageSource messageSource, @NonNull List<WebErrorHandler> webErrorHandlers, @Nullable WebErrorHandler defaultWebErrorHandler, @NonNull ExceptionRefiner exceptionRefiner, @NonNull ExceptionLogger exceptionLogger, @NonNull List<WebErrorHandlerPostProcessor> webErrorHandlerPostProcessors, @NonNull FingerprintProvider fingerprintProvider, @NonNull ErrorsProperties errorsProperties) {
        this.errorsProperties = Objects.requireNonNull(errorsProperties);
        this.messageSource = new TemplateAwareMessageSource(Objects.requireNonNull(messageSource, "We need a MessageSource implementation to message translation"));
        this.webErrorHandlers = WebErrorHandlers.requireAtLeastOneHandler(webErrorHandlers);
        if (defaultWebErrorHandler != null) {
            this.defaultWebErrorHandler = defaultWebErrorHandler;
        }
        this.exceptionRefiner = Objects.requireNonNull(exceptionRefiner);
        this.exceptionLogger = Objects.requireNonNull(exceptionLogger);
        this.webErrorHandlerPostProcessors = Objects.requireNonNull(webErrorHandlerPostProcessors);
        this.fingerprintProvider = Objects.requireNonNull(fingerprintProvider);
    }

    public static WebErrorHandlersBuilder builder(@NonNull MessageSource messageSource) {
        return new WebErrorHandlersBuilder(messageSource);
    }

    private static <T> List<T> requireAtLeastOneHandler(List<T> handlers) {
        if (Objects.requireNonNull(handlers, "Collection of error handlers is required").isEmpty()) {
            throw new IllegalArgumentException("We need at least one error handler");
        }
        return handlers;
    }

    @NonNull
    public HttpError handle(@Nullable Throwable originalException, @Nullable Object httpRequest, @Nullable Locale locale) {
        if (locale == null) {
            locale = Locale.ROOT;
        }
        this.exceptionLogger.log(originalException);
        log.debug("About to handle an exception", originalException);
        Throwable exception = this.refineIfNeeded(originalException);
        WebErrorHandler handler = this.findHandler(exception);
        log.debug("The '{}' is going to handle the '{}' exception", (Object)this.className(handler), (Object)this.className(exception));
        HandledException handled = handler.handle(exception);
        List<HttpError.CodedMessage> codeWithMessages = this.translateErrors(handled, locale);
        HttpError httpError = new HttpError(codeWithMessages, handled.getStatusCode());
        httpError.setOriginalException(originalException);
        httpError.setRefinedException(exception);
        httpError.setRequest(httpRequest);
        if (this.errorsProperties.isAddFingerprint()) {
            String fingerprint = this.fingerprintProvider.generate(httpError);
            log.debug("Generated fingerprint: {}", (Object)fingerprint);
            httpError.setFingerprint(fingerprint);
        }
        log.debug("About to execute {} error handler post processors", (Object)this.webErrorHandlerPostProcessors.size());
        this.webErrorHandlerPostProcessors.forEach(p -> p.process(httpError));
        return httpError;
    }

    private Throwable refineIfNeeded(Throwable exception) {
        Throwable refined = this.exceptionRefiner.refine(exception);
        if (refined != null) {
            log.debug("The caught exception got refined", refined);
            return refined;
        }
        return exception;
    }

    private List<HttpError.CodedMessage> translateErrors(HandledException handled, Locale locale) {
        return handled.getErrorCodes().stream().map(code -> this.withMessage((String)code, this.getArgumentsFor(handled, (String)code), locale)).collect(Collectors.toList());
    }

    private HttpError.CodedMessage withMessage(String code, List<Argument> arguments, Locale locale) {
        try {
            String message = this.messageSource.interpolate(code, arguments, locale);
            return new HttpError.CodedMessage(code, message, arguments);
        }
        catch (Exception e) {
            return new HttpError.CodedMessage(code, null, arguments);
        }
    }

    private WebErrorHandler findHandler(Throwable exception) {
        if (exception == null) {
            return this.defaultWebErrorHandler;
        }
        return this.webErrorHandlers.stream().filter(p -> p.canHandle(exception)).findFirst().orElse(this.defaultWebErrorHandler);
    }

    private String className(Object toInspect) {
        if (toInspect == null) {
            return "null";
        }
        return toInspect.getClass().getName();
    }

    private List<Argument> getArgumentsFor(HandledException handled, String errorCode) {
        return handled.getArguments().getOrDefault(errorCode, Collections.emptyList());
    }
}

