/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.alidg.errors.Argument;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class HttpError {
    private final List<CodedMessage> errors;
    private final HttpStatus httpStatus;
    @Nullable
    private String fingerprint;
    @Nullable
    private Object request;
    @Nullable
    private Throwable originalException;
    @Nullable
    private Throwable refinedException;

    public HttpError(List<CodedMessage> errors, HttpStatus httpStatus) {
        this.errors = errors;
        this.httpStatus = httpStatus;
    }

    public List<CodedMessage> getErrors() {
        return this.errors;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public Throwable getOriginalException() {
        return this.originalException;
    }

    public void setOriginalException(Throwable originalException) {
        this.originalException = originalException;
    }

    public Throwable getRefinedException() {
        return this.refinedException;
    }

    public void setRefinedException(Throwable refinedException) {
        this.refinedException = refinedException;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String toString() {
        return "HttpError{errors=" + this.errors + ", httpStatus=" + this.httpStatus + ", fingerprint=" + this.fingerprint + '}';
    }

    public static class CodedMessage {
        private final String code;
        private final String message;
        private final List<Argument> arguments;

        public CodedMessage(@NonNull String code, String message, @NonNull List<Argument> arguments) {
            this.code = Objects.requireNonNull(code, "The error code is required");
            this.message = message;
            this.arguments = Objects.requireNonNull(arguments, "Arguments can not be null");
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public List<Argument> getArguments() {
            return Collections.unmodifiableList(this.arguments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CodedMessage)) {
                return false;
            }
            CodedMessage that = (CodedMessage)o;
            return Objects.equals(this.getCode(), that.getCode()) && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getArguments(), that.getArguments());
        }

        public int hashCode() {
            return Objects.hash(this.getCode(), this.getMessage(), this.getArguments());
        }

        public String toString() {
            return "CodedMessage{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", arguments=" + this.arguments + '}';
        }
    }
}

