/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class SpringSecurityWebErrorHandler
implements WebErrorHandler {
    public static final String ACCESS_DENIED = "security.access_denied";
    public static final String ACCOUNT_EXPIRED = "security.account_expired";
    public static final String AUTH_REQUIRED = "security.auth_required";
    public static final String INTERNAL_ERROR = "security.internal_error";
    public static final String BAD_CREDENTIALS = "security.bad_credentials";
    public static final String USER_LOCKED = "security.user_locked";
    public static final String USER_DISABLED = "security.user_disabled";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof AccessDeniedException || exception instanceof AuthenticationException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        if (exception instanceof AccessDeniedException) {
            return new HandledException(ACCESS_DENIED, HttpStatus.FORBIDDEN, null);
        }
        if (exception instanceof AccountExpiredException) {
            return new HandledException(ACCOUNT_EXPIRED, HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof AuthenticationCredentialsNotFoundException) {
            return new HandledException(AUTH_REQUIRED, HttpStatus.UNAUTHORIZED, null);
        }
        if (exception instanceof AuthenticationServiceException) {
            return new HandledException(INTERNAL_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, null);
        }
        if (exception instanceof BadCredentialsException) {
            return new HandledException(BAD_CREDENTIALS, HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof UsernameNotFoundException) {
            return new HandledException(BAD_CREDENTIALS, HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof InsufficientAuthenticationException) {
            return new HandledException(AUTH_REQUIRED, HttpStatus.UNAUTHORIZED, null);
        }
        if (exception instanceof LockedException) {
            return new HandledException(USER_LOCKED, HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof DisabledException) {
            return new HandledException(USER_DISABLED, HttpStatus.BAD_REQUEST, null);
        }
        return new HandledException("unknown_error", HttpStatus.INTERNAL_SERVER_ERROR, null);
    }
}

